/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import thunderheadeng.util.MetaPool;

public class Meta
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private final MetaPool d_pool;
    private HashMap<Serializable, Serializable> d_table = new HashMap();

    protected Meta() {
        this(null);
    }

    public Meta(MetaPool pool) {
        this.d_pool = pool;
    }

    public <T extends MetaPool> T getPool() {
        return (T)this.d_pool;
    }

    public boolean isSet(Object key) {
        return this.d_table.containsKey(key);
    }

    public <T extends Serializable> T get(Serializable key) {
        return (T)this.d_table.get(key);
    }

    public <T extends Serializable> void lightSet(Serializable key, T val) {
        this.d_table.put(key, val);
    }

    public <T extends Serializable> void lightMultiSet(Serializable val, Serializable ... keys) {
        for (Serializable key : keys) {
            this.d_table.put(key, val);
        }
    }

    public <T extends Serializable> Meta set(Serializable key, T val) {
        Meta newMeta = (Meta)this.clone();
        newMeta.lightSet(key, val);
        return this.d_pool.get(newMeta);
    }

    public <T extends Serializable> Meta multiSet(Serializable val, Serializable ... keys) {
        Meta newMeta = (Meta)this.clone();
        newMeta.lightMultiSet(val, keys);
        return this.d_pool.get(newMeta);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.d_pool != null) {
            this.d_pool.get(this);
        }
    }

    protected Object clone() {
        try {
            Meta clone = (Meta)super.clone();
            clone.d_table = (HashMap)this.d_table.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public int hashCode() {
        int hash = 0;
        for (Map.Entry<Serializable, Serializable> entry : this.d_table.entrySet()) {
            int ehash = entry.getKey().hashCode() & 0xFFFF0000;
            if (entry.getValue() != null) {
                ehash |= entry.getValue().hashCode();
            }
            hash += ehash;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Meta)) {
            return false;
        }
        Meta meta = (Meta)obj;
        return this == obj || this.d_table.equals(meta.d_table);
    }
}

