/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import thunderheadeng.util.IHasher;
import thunderheadeng.util.IdentityHasher;
import thunderheadeng.util.JavaHasher;

public class ListSet<T>
extends AbstractSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IHasher<T> d_hasher;
    private final List<T> d_elements;

    public ListSet() {
        this(JavaHasher.INSTANCE);
    }

    public ListSet(int initCapacity) {
        this(initCapacity, JavaHasher.INSTANCE);
    }

    public ListSet(T ... objs) {
        this((IHasher<T>)JavaHasher.INSTANCE, objs);
    }

    public ListSet(Collection<? extends T> objs) {
        this((IHasher<? extends T>)JavaHasher.INSTANCE, objs);
    }

    public ListSet(IHasher<T> hasher) {
        this.d_elements = new ArrayList<T>();
        this.d_hasher = hasher;
    }

    public ListSet(int initCapacity, IHasher<T> hasher) {
        this.d_elements = new ArrayList<T>(initCapacity);
        this.d_hasher = hasher;
    }

    public ListSet(IHasher<T> hasher, T ... objs) {
        this.d_elements = Arrays.asList(objs);
        this.d_hasher = hasher;
    }

    public ListSet(IHasher<T> hasher, Collection<? extends T> objs) {
        this.d_elements = new ArrayList<T>(objs);
        this.d_hasher = hasher;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.d_hasher.getClass().equals(IdentityHasher.class)) {
            this.d_hasher = IdentityHasher.INSTANCE;
        } else if (this.d_hasher.getClass().equals(JavaHasher.class)) {
            this.d_hasher = JavaHasher.INSTANCE;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set set2 = (Set)o;
        if (this.size() != set2.size()) {
            return false;
        }
        for (T obj : this.d_elements) {
            boolean found = false;
            for (Object obj2 : set2) {
                if (!this.d_hasher.equal(obj, obj2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (T obj : this.d_elements) {
            hash += this.d_hasher.hash(obj);
        }
        return hash;
    }

    @Override
    public boolean add(T o) {
        if (!this.contains(o)) {
            return this.d_elements.add(o);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        for (int m = 0; m < this.d_elements.size(); ++m) {
            T obj = this.d_elements.get(m);
            if (!this.d_hasher.equal(obj, o)) continue;
            this.d_elements.remove(m);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        for (T obj : this.d_elements) {
            if (!this.d_hasher.equal(obj, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.d_elements.clear();
    }

    @Override
    public Object[] toArray() {
        return this.d_elements.toArray();
    }

    @Override
    public <T2> T2[] toArray(T2[] a) {
        return this.d_elements.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.d_elements.iterator();
    }

    @Override
    public int size() {
        return this.d_elements.size();
    }
}

