/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import thunderheadeng.util.Keyable;

public class KeyGenerator {
    private static final Random s_rand = new Random();
    public static final int NO_KEY = 0;
    private final Map<Integer, WeakReference<Keyable>> d_objects = Collections.synchronizedMap(new HashMap());
    private int d_reserveKeysCount = 0;
    private Set<Integer> d_reservedKeys = new HashSet<Integer>();

    public int getNumKeys() {
        return this.d_objects.size();
    }

    public synchronized void beginReserveKeys() {
        ++this.d_reserveKeysCount;
    }

    public synchronized void endReserveKeys() {
        if (--this.d_reserveKeysCount == 0 && !this.d_reservedKeys.isEmpty()) {
            this.d_reservedKeys = new HashSet<Integer>();
        }
    }

    public Keyable get(Integer key) {
        if (key == null) {
            return null;
        }
        WeakReference<Keyable> ref = this.d_objects.get(key);
        return ref != null ? (Keyable)ref.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Integer generateKey(Keyable obj) {
        Set<Object> reserved = this.isReservingKeys() ? this.d_reservedKeys : Collections.emptySet();
        int key = System.identityHashCode(obj);
        Map<Integer, WeakReference<Keyable>> map = this.d_objects;
        synchronized (map) {
            while (key == 0 || this.d_objects.containsKey(key) || reserved.contains(key)) {
                key = s_rand.nextInt();
            }
            Integer val = key;
            this.d_objects.put(val, new WeakReference<Keyable>(obj));
            return val;
        }
    }

    public void registerKey(Keyable obj, Integer key) {
        WeakReference<Keyable> existing = this.d_objects.put(key, new WeakReference<Keyable>(obj));
        assert (existing == null || existing.get() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnKey(Integer key, Keyable source) {
        if (key == null) {
            return false;
        }
        Object object = this.d_objects;
        synchronized (object) {
            Keyable currMapping = this.get(key);
            if (currMapping == null || currMapping == source) {
                return this.d_objects.remove(key) != null;
            }
        }
        object = this;
        synchronized (object) {
            if (this.isReservingKeys()) {
                this.d_reservedKeys.add(key);
            }
        }
        return false;
    }

    private boolean isReservingKeys() {
        return this.d_reserveKeysCount > 0;
    }
}

