/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;

public class IdentityHashSet<T>
implements Set<T>,
Serializable {
    static final long serialVersionUID = 1L;
    private final IdentityHashMap<T, T> d_map;

    public IdentityHashSet() {
        this.d_map = new IdentityHashMap();
    }

    public IdentityHashSet(int expectedMaxSize) {
        this.d_map = new IdentityHashMap(expectedMaxSize);
    }

    public IdentityHashSet(Collection<? extends T> set) {
        this.d_map = new IdentityHashMap(set.size());
        for (T obj : set) {
            this.add(obj);
        }
    }

    @Override
    public int size() {
        return this.d_map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d_map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.d_map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.d_map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.d_map.keySet().toArray();
    }

    @Override
    public <T2> T2[] toArray(T2[] a) {
        return this.d_map.keySet().toArray(a);
    }

    @Override
    public boolean add(T o) {
        if (this.d_map.containsKey(o)) {
            return false;
        }
        this.d_map.put(o, null);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean allAdded = true;
        for (T o : c) {
            allAdded &= this.add(o);
        }
        return allAdded;
    }

    @Override
    public boolean remove(Object o) {
        return this.d_map.keySet().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.d_map.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.d_map.keySet().retainAll(c);
    }

    @Override
    public void clear() {
        this.d_map.clear();
    }

    @Override
    public int hashCode() {
        return this.d_map.keySet().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        return this.d_map.keySet().equals(obj);
    }

    public String toString() {
        return this.d_map.keySet().toString();
    }
}

