/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FlattenedList<ElemT>
extends AbstractList<ElemT> {
    private final List<? extends List<ElemT>> d_lists;
    private int[] d_offsets;
    private Integer d_count;

    public FlattenedList(List<? extends List<ElemT>> lists) {
        this.d_lists = lists;
    }

    private void cacheOffsets() {
        if (this.d_offsets != null) {
            return;
        }
        this.d_offsets = new int[this.d_lists.size()];
        int offset = 0;
        for (int m = 0; m < this.d_lists.size(); ++m) {
            this.d_offsets[m] = offset;
            offset += this.d_lists.get(m).size();
        }
        this.d_count = offset;
    }

    @Override
    public synchronized ElemT get(int primIx) {
        this.cacheOffsets();
        int ix = Arrays.binarySearch(this.d_offsets, primIx);
        if (ix < 0) {
            ix -= 2;
        }
        assert (ix >= 0);
        int offset = this.d_offsets[ix];
        return this.d_lists.get(ix).get(primIx - offset);
    }

    @Override
    public synchronized int size() {
        this.cacheOffsets();
        return this.d_count;
    }

    @Override
    public Iterator<ElemT> iterator() {
        return new It();
    }

    private class It
    implements Iterator<ElemT> {
        private Iterator<? extends List<ElemT>> d_suppliersIt;
        private Iterator<ElemT> d_supplierIt = null;

        private It() {
            this.d_suppliersIt = FlattenedList.this.d_lists.iterator();
            this.prefetchNext();
            if (this.d_supplierIt == null) {
                this.d_supplierIt = Collections.emptyIterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.d_supplierIt.hasNext();
        }

        @Override
        public ElemT next() {
            Object next = this.d_supplierIt.next();
            if (!this.d_supplierIt.hasNext()) {
                this.prefetchNext();
            }
            return next;
        }

        private void prefetchNext() {
            while (this.d_suppliersIt.hasNext()) {
                List supplier = this.d_suppliersIt.next();
                this.d_supplierIt = supplier.iterator();
                if (!this.d_supplierIt.hasNext()) continue;
                break;
            }
        }
    }
}

