/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Collection;
import java.util.function.Predicate;
import thunderheadeng.util.AFilteredCollection;
import thunderheadeng.util.FilteredIterator2;

public class FilteredCollection2<T>
extends AFilteredCollection<T, T> {
    private final Predicate<? super T> d_filter;

    public FilteredCollection2(Collection<? extends T> objs, Predicate<? super T> filter) {
        super(objs);
        this.d_filter = filter;
    }

    public Predicate<? super T> getFilter() {
        return this.d_filter;
    }

    @Override
    public FilteredIterator2<T> iterator() {
        return new FilteredIterator2<T>(this.getUnfiltered().iterator(), this.d_filter);
    }

    @Override
    protected boolean accept(Object o) {
        try {
            Object tobj = o;
            return this.d_filter.test(tobj);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.getUnfiltered().contains(o) && this.d_filter.test(o);
    }
}

