/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;

public class FilterMgr {
    private final Events d_events;
    private final Map<Class, Predicate> d_filters = new HashMap<Class, Predicate>();
    private final Map<Class, Predicate> d_cachedFilters = new HashMap<Class, Predicate>();

    public FilterMgr(Events evts) {
        this.d_events = evts;
    }

    protected void changed(Class type) {
        this.d_cachedFilters.clear();
        if (this.d_events != null) {
            this.d_events.changed(this, type);
        }
    }

    public <T> void registerFilter(Class<T> clazz, Predicate<? extends T> filter) {
        Predicate<? extends T> old;
        assert (filter != null) : "Filter must not be null. To remove a filter, use the method, removeFilter.";
        if (Filters.alwaysFalse(filter) && !filter.equals(old = this.d_filters.put(clazz, filter))) {
            this.changed(clazz);
            return;
        }
        Predicate oldFilter = this.d_filters.get(clazz);
        if (oldFilter instanceof CompositeFilter) {
            if (((CompositeFilter)oldFilter).add(filter)) {
                this.changed(clazz);
            }
        } else if (oldFilter != null && !filter.equals(oldFilter)) {
            CompositeFilter newFilter = new CompositeFilter(oldFilter, filter);
            this.d_filters.put(clazz, newFilter);
            this.changed(clazz);
        } else {
            this.d_filters.put(clazz, filter);
            this.changed(clazz);
        }
    }

    public <T> void filterAllOfType(Class<T> type) {
        this.registerFilter(type, Filters.rejectAll(type));
    }

    public <T> void removeFilter(Class<T> clazz, Predicate<T> filter) {
        Predicate existing = this.d_filters.get(clazz);
        if (existing instanceof CompositeFilter) {
            CompositeFilter cf = (CompositeFilter)existing;
            if (cf.remove(filter)) {
                if (cf.d_filters.size() == 1) {
                    this.d_filters.put(clazz, (Predicate)cf.d_filters.get(0));
                }
                this.changed(clazz);
            }
        } else if (filter.equals(existing)) {
            this.d_filters.remove(clazz);
            this.changed(clazz);
        }
    }

    public boolean isFilteringAllOf(Class type) {
        Predicate filter = this.getFilter(type);
        return Filters.alwaysFalse(filter);
    }

    public boolean filter(Object obj) {
        Predicate filter = this.getFilter(obj.getClass());
        if (filter == null) {
            return false;
        }
        return !filter.test(obj);
    }

    private Predicate getFilter(Class clazz) {
        if (this.d_cachedFilters.containsKey(clazz)) {
            return this.d_cachedFilters.get(clazz);
        }
        Predicate filter = this.calculateFilter(clazz);
        this.d_cachedFilters.put(clazz, filter);
        return filter;
    }

    private Predicate calculateFilter(Class clazz) {
        Predicate filter = this.d_filters.get(clazz);
        if (filter != null) {
            return filter;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (filter = this.calculateFilter(superClass)) != null) {
            return filter;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            filter = this.calculateFilter(iface);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    public void reset() {
        this.d_filters.clear();
        if (this.d_events != null) {
            this.d_events.changed(this, new Object[0]);
        }
    }

    private static class CompositeFilter<T>
    implements Predicate<T> {
        private final List<Predicate<T>> d_filters;

        public CompositeFilter(Predicate<T> ... filters) {
            this.d_filters = new ArrayList<Predicate<T>>(Arrays.asList(filters));
        }

        public boolean add(Predicate<T> filter) {
            int ix = this.d_filters.indexOf(filter);
            if (ix < 0) {
                this.d_filters.add(filter);
                return true;
            }
            return false;
        }

        public boolean remove(Predicate<T> filter) {
            return this.d_filters.remove(filter);
        }

        @Override
        public boolean test(T t) {
            for (Predicate<T> filter : this.d_filters) {
                if (filter.test(t)) continue;
                return false;
            }
            return true;
        }
    }
}

