/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.AEventRec;
import thunderheadeng.util.EmptyEventRec;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class EventChannel<ObjT>
extends AEventRec<ObjT> {
    public static final Object EVT_GENERAL = Events.EVT_GENERAL;
    private final Set<ObjT> d_adds;
    private final Set<ObjT> d_removes;
    private final Map<Object, Set<ObjT>> d_changeMap;
    private final Class<ObjT> d_type;
    private final boolean d_identityObjHash;
    private final Predicate<? super ObjT> d_filter;

    public EventChannel(Class<ObjT> objType, boolean identityObjHash) {
        this.d_type = objType;
        this.d_identityObjHash = identityObjHash;
        this.d_adds = this.newObjSet();
        this.d_removes = this.newObjSet();
        this.d_changeMap = new LinkedHashMap<Object, Set<ObjT>>();
        this.d_filter = Predicates.alwaysTrue();
    }

    protected EventChannel(Class<ObjT> type, Set<ObjT> adds, Set<ObjT> removes, Map<Object, Set<ObjT>> changeMap, boolean identityObjHash, Predicate<? super ObjT> filter) {
        this.d_type = type;
        this.d_adds = adds;
        this.d_removes = removes;
        this.d_changeMap = changeMap;
        this.d_identityObjHash = identityObjHash;
        this.d_filter = filter;
    }

    @Override
    public IEventRecord<ObjT> filter(Predicate<? super ObjT> filter) {
        if (Predicates.alwaysTrue(filter)) {
            return this;
        }
        if (Predicates.alwaysFalse(filter)) {
            return EmptyEventRec.INSTANCE;
        }
        return new EventChannel<ObjT>(this.d_type, this.d_adds, this.d_removes, this.d_changeMap, this.d_identityObjHash, filter);
    }

    public Class<ObjT> getObjectType() {
        return this.d_type;
    }

    public Predicate<? super ObjT> getFilter() {
        return this.d_filter;
    }

    public boolean handlesSubType(Class type) {
        return type.isAssignableFrom(this.d_type);
    }

    protected Set<ObjT> newObjSet() {
        return this.d_identityObjHash ? new LinkedIdentityHashSet() : new LinkedHashSet();
    }

    public boolean added(ObjT obj) {
        if (!this.d_removes.remove(obj)) {
            this.d_adds.add(obj);
            return true;
        }
        return this.changed(obj, new Object[0]);
    }

    public boolean added(ObjT ... objs) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            if (!this.added(obj)) continue;
            evtFired = true;
        }
        return evtFired;
    }

    public boolean added(Collection<? extends ObjT> objs) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            if (!this.added(obj)) continue;
            evtFired = true;
        }
        return evtFired;
    }

    private void removeChangesTo(ObjT obj) {
        Iterator<Map.Entry<Object, Set<ObjT>>> changeIt = this.d_changeMap.entrySet().iterator();
        while (changeIt.hasNext()) {
            Map.Entry<Object, Set<ObjT>> entry = changeIt.next();
            Set<ObjT> objs = entry.getValue();
            if (!objs.remove(obj) || !objs.isEmpty()) continue;
            changeIt.remove();
        }
    }

    private void addChangeTo(ObjT obj, Object change) {
        Set<ObjT> changedObjs = this.d_changeMap.get(change);
        if (changedObjs == null) {
            changedObjs = this.newObjSet();
            this.d_changeMap.put(change, changedObjs);
        }
        changedObjs.add(obj);
    }

    public boolean removed(ObjT obj) {
        if (!this.d_adds.remove(obj)) {
            this.removeChangesTo(obj);
            this.d_removes.add(obj);
            return true;
        }
        return false;
    }

    public boolean removed(ObjT ... objs) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            evtFired |= this.removed(obj);
        }
        return evtFired;
    }

    public boolean removed(Collection<? extends ObjT> objs) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            evtFired |= this.removed(obj);
        }
        return evtFired;
    }

    public boolean changed(ObjT obj, Object ... changes) {
        if (!this.d_adds.contains(obj) && !this.d_removes.contains(obj)) {
            if (changes.length == 0) {
                this.addChangeTo(obj, EVT_GENERAL);
            } else {
                for (Object change : changes) {
                    this.addChangeTo(obj, change);
                }
            }
            return true;
        }
        return false;
    }

    public boolean changed(Collection<? extends ObjT> objs, Object ... changes) {
        boolean evtFired = false;
        for (ObjT obj : objs) {
            evtFired |= this.changed(obj, changes);
        }
        return evtFired;
    }

    @Override
    private Set<ObjT> filter(Set<ObjT> objs) {
        return theUtil.filter(objs, this.d_filter);
    }

    @Override
    public Set<ObjT> getAddedObjs() {
        return this.filter(Collections.unmodifiableSet(this.d_adds));
    }

    @Override
    public Set<ObjT> getRemovedObjs() {
        return this.filter(Collections.unmodifiableSet(this.d_removes));
    }

    @Override
    public Set<Object> getChanges() {
        if (this.d_changeMap.isEmpty() || Predicates.alwaysTrue(this.d_filter)) {
            return Collections.unmodifiableSet(this.d_changeMap.keySet());
        }
        return theUtil.map(theUtil.filter(this.d_changeMap.entrySet(), e -> !this.filter((Set)e.getValue()).isEmpty()), e -> e.getKey());
    }

    @Override
    public void getChanges(Object obj, Collection<Object> changes) {
        if (this.d_type.isInstance(obj) && !this.d_filter.test(obj)) {
            return;
        }
        for (Map.Entry<Object, Set<ObjT>> entry : this.d_changeMap.entrySet()) {
            if (!entry.getValue().contains(obj)) continue;
            changes.add(entry.getKey());
        }
    }

    @Override
    public Set<ObjT> getChangedObjs(Predicate<Object> changeFilter) {
        if (this.d_changeMap.isEmpty() || changeFilter == Filters.rejectAll()) {
            return Collections.EMPTY_SET;
        }
        int acceptedCount = 0;
        Set<ObjT> objs = Collections.EMPTY_SET;
        for (Map.Entry<Object, Set<ObjT>> entry : this.d_changeMap.entrySet()) {
            if (!changeFilter.test(entry.getKey())) continue;
            if (acceptedCount == 0) {
                objs = this.filter(entry.getValue());
            } else {
                if (acceptedCount == 1) {
                    Set<ObjT> newObjs = this.newObjSet();
                    newObjs.addAll(this.filter(objs));
                    objs = newObjs;
                }
                objs.addAll(this.filter(entry.getValue()));
            }
            ++acceptedCount;
        }
        return objs;
    }

    @Override
    public Set<ObjT> getChangedObjs(Object ... changes) {
        if (this.d_changeMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (changes.length == 0) {
            if (this.d_changeMap.size() == 1) {
                return this.filter(this.d_changeMap.values().iterator().next());
            }
            Set<ObjT> allObjs = this.newObjSet();
            for (Set<ObjT> objs : this.d_changeMap.values()) {
                allObjs.addAll(this.filter(objs));
            }
            return allObjs;
        }
        if (changes.length == 1) {
            Set<ObjT> changedObjs = this.d_changeMap.get(changes[0]);
            if (changedObjs == null) {
                return Collections.EMPTY_SET;
            }
            return this.filter(changedObjs);
        }
        Set<ObjT> objs = this.newObjSet();
        for (Object change : changes) {
            Set<ObjT> changedObjs = this.d_changeMap.get(change);
            if (changedObjs == null) continue;
            objs.addAll(this.filter(changedObjs));
        }
        return objs;
    }

    @Override
    public boolean isChanged(Object obj) {
        if (this.d_type.isInstance(obj) && !this.d_filter.test(obj)) {
            return false;
        }
        for (Set<ObjT> changedObjs : this.d_changeMap.values()) {
            if (!changedObjs.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChanged(Object obj, Object change) {
        if (this.d_type.isInstance(obj) && !this.d_filter.test(obj)) {
            return false;
        }
        return this.d_changeMap.getOrDefault(change, Collections.emptySet()).contains(obj);
    }

    @Override
    public boolean containsChange(Object change) {
        Set<ObjT> changedObjs = this.d_changeMap.get(change);
        if (changedObjs == null) {
            return false;
        }
        return !this.filter(changedObjs).isEmpty();
    }

    protected void eventDispatched() {
        this.d_adds.clear();
        this.d_removes.clear();
        this.d_changeMap.clear();
    }

    public String toString() {
        return "EventChannel of " + this.d_type;
    }
}

