/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Arrays;
import java.util.Iterator;

public class CompositeIterator<E>
implements Iterator<E> {
    private Iterator<? extends Iterable<? extends E>> d_collIt;
    private Iterator<? extends E> d_currIt;

    public CompositeIterator(Iterable<? extends E> ... collections) {
        this((Iterable<Iterable<? extends E>>)Arrays.asList(collections));
    }

    public CompositeIterator(Iterable<? extends Iterable<? extends E>> collections) {
        this.d_collIt = collections.iterator();
        this.d_currIt = null;
    }

    protected void update() {
        if (this.d_currIt != null && this.d_currIt.hasNext()) {
            return;
        }
        this.d_currIt = null;
        while (this.d_collIt.hasNext()) {
            Iterator<E> it = this.d_collIt.next().iterator();
            if (!it.hasNext()) continue;
            this.d_currIt = it;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        this.update();
        return this.d_currIt != null;
    }

    @Override
    public E next() {
        this.update();
        return this.d_currIt == null ? null : (E)this.d_currIt.next();
    }

    @Override
    public void remove() {
        this.update();
        if (this.d_currIt != null) {
            this.d_currIt.remove();
        }
    }
}

