/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import thunderheadeng.util.BitOptions;

public class CSVLineParser {
    public static final int KEEP_QUOTE = 1;
    public static final int KEEP_ESCAPE = 2;
    public static final int KEEP_ALL = 3;

    public static List<String> parse(String line, String delims, String qChars) {
        return CSVLineParser.parse(new ArrayList<String>(), line, delims, qChars);
    }

    public static List<String> parse(List<String> vals, String line, String delims, String qChars) {
        return CSVLineParser.parse(vals, line, delims, qChars, null);
    }

    public static List<String> parse(String line, String delims, String qChars, BitSet quotedValues) {
        return CSVLineParser.parse(new ArrayList<String>(), line, delims, qChars, quotedValues);
    }

    public static List<String> parse(List<String> vals, String line, String delims, String qChars, BitSet quotedValues) {
        return CSVLineParser.parse(vals, line, delims, qChars, quotedValues, null, 0);
    }

    public static List<String> parse(List<String> vals, String line, String delims, String qChars, BitSet quotedValues, Character escapeChar, int options) {
        if (line == null) {
            return vals;
        }
        BitOptions opts = new BitOptions(options);
        boolean keepQuotes = opts.get(1L);
        boolean keepEscapes = opts.get(2L);
        assert (qChars.isEmpty() || qChars.length() == 1 || qChars.length() % 2 == 0);
        StringBuilder sb = new StringBuilder();
        boolean inQuote = false;
        boolean quoteCompleted = false;
        char endQuoteChar = '\u0000';
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (escapeChar != null && c == escapeChar.charValue()) {
                if (++i >= line.length()) break;
                char escapedChar = line.charAt(i);
                if (keepEscapes) {
                    sb.append(c);
                }
                sb.append(escapedChar);
                continue;
            }
            if (delims.indexOf(c) != -1) {
                if (!inQuote) {
                    CSVLineParser.addTok(vals, sb, quoteCompleted, quotedValues);
                    quoteCompleted = false;
                    sb.delete(0, sb.length());
                    continue;
                }
                sb.append(c);
                continue;
            }
            int qix = qChars.indexOf(c);
            if (qix != -1) {
                if (!(inQuote || qChars.length() != 1 && qix % 2 != 0)) {
                    endQuoteChar = qChars.length() == 1 ? c : qChars.charAt(qix + 1);
                    quoteCompleted = false;
                    inQuote = true;
                    if (!keepQuotes) continue;
                    sb.append(c);
                    continue;
                }
                if (inQuote && c == endQuoteChar) {
                    inQuote = false;
                    quoteCompleted = true;
                    if (!keepQuotes) continue;
                    sb.append(c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        CSVLineParser.addTok(vals, sb, quoteCompleted, quotedValues);
        return vals;
    }

    private static void addTok(List<String> vals, StringBuilder sb, boolean quoteCompleted, BitSet quotedValues) {
        int tbegin;
        int tend = sb.length();
        for (tbegin = 0; tbegin < tend && sb.charAt(tbegin) == ' '; ++tbegin) {
        }
        while (tend > tbegin && sb.charAt(tend - 1) == ' ') {
            --tend;
        }
        if (tend - tbegin > 0 || quoteCompleted) {
            String tok = sb.substring(tbegin, tend);
            if (quoteCompleted && quotedValues != null) {
                quotedValues.set(vals.size(), true);
            }
            vals.add(tok);
        }
    }
}

