/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

public class RayPointProx
implements Comparable<RayPointProx> {
    private final double d_zDist;
    private final double d_rDist;
    private final double d_rcomp;
    private final double d_zcomp;

    public RayPointProx(double zDist, double rDist) {
        assert (!Double.isNaN(zDist));
        assert (!Double.isNaN(rDist));
        this.d_zDist = zDist;
        this.d_rDist = rDist;
        this.d_rcomp = Math.floor(rDist * 1000000.0);
        this.d_zcomp = Math.floor(zDist * 1000000.0);
    }

    @Override
    public int compareTo(RayPointProx o) {
        if (o == this) {
            return 0;
        }
        int rcompare = Double.compare(this.d_rcomp, o.d_rcomp);
        if (rcompare != 0) {
            return rcompare;
        }
        int zcompare = Double.compare(this.d_zcomp, o.d_zcomp);
        if (zcompare != 0) {
            return zcompare;
        }
        return 0;
    }

    public double getZDist() {
        return this.d_zDist;
    }

    public double getRDist() {
        return this.d_rDist;
    }
}

