/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.scene3d.picking.PointConstraint;
import thunderheadeng.util.theUtil;

public class ConstraintUtil {
    public static boolean conflict(ISnapConstraint sc1, ISnapConstraint sc2) {
        if (sc1 == null || sc2 == null) {
            return false;
        }
        int rank1 = ConstraintUtil.rank(sc1);
        int rank2 = ConstraintUtil.rank(sc2);
        if (rank2 < rank1) {
            ISnapConstraint temp = sc1;
            sc1 = sc2;
            sc2 = temp;
        }
        if (sc1 instanceof LineConstraint) {
            LineConstraint lc1 = (LineConstraint)sc1;
            if (sc2 instanceof LineConstraint) {
                LineConstraint lc2 = (LineConstraint)sc2;
                Vector3d dir1 = Util3D.normalize(lc1.dir);
                Vector3d dir2 = Util3D.normalize(lc2.dir);
                return theUtil.eq0(dir1.dot(dir2), 1.0E-9);
            }
            if (sc2 instanceof PlanarConstraint) {
                PlanarConstraint pc2 = (PlanarConstraint)sc2;
                Vector3d dir1 = Util3D.normalize(lc1.dir);
                Vector3d norm = pc2.plane.getNormal();
                double adot = Math.abs(dir1.dot(norm));
                return theUtil.eq(adot, 1.0, 1.0E-9);
            }
        }
        return false;
    }

    public static ISnapConstraint intersect(ISnapConstraint sc1, ISnapConstraint sc2) throws NoIntersectionException {
        if (sc1 == null && sc2 == null) {
            return null;
        }
        if (sc1 == null) {
            return sc2;
        }
        if (sc2 == null) {
            return sc1;
        }
        int rank1 = ConstraintUtil.rank(sc1);
        int rank2 = ConstraintUtil.rank(sc2);
        if (rank2 < rank1) {
            ISnapConstraint temp = sc1;
            sc1 = sc2;
            sc2 = temp;
        }
        if (sc1 instanceof PointConstraint) {
            if (sc2 instanceof PointConstraint) {
                return ConstraintUtil.intersect((PointConstraint)sc1, (PointConstraint)sc2);
            }
            if (sc2 instanceof LineConstraint) {
                return ConstraintUtil.intersect((PointConstraint)sc1, (LineConstraint)sc2);
            }
            if (sc2 instanceof PlanarConstraint) {
                return ConstraintUtil.intersect((PointConstraint)sc1, (PlanarConstraint)sc2);
            }
        } else if (sc1 instanceof LineConstraint) {
            if (sc2 instanceof LineConstraint) {
                return ConstraintUtil.intersect((LineConstraint)sc1, (LineConstraint)sc2);
            }
            if (sc2 instanceof PlanarConstraint) {
                return ConstraintUtil.intersect((LineConstraint)sc1, (PlanarConstraint)sc2);
            }
        } else if (sc1 instanceof PlanarConstraint && sc2 instanceof PlanarConstraint) {
            return ConstraintUtil.intersect((PlanarConstraint)sc1, (PlanarConstraint)sc2);
        }
        throw new NoIntersectionException();
    }

    private static int rank(ISnapConstraint constraint) {
        if (constraint instanceof PointConstraint) {
            return 0;
        }
        if (constraint instanceof LineConstraint) {
            return 1;
        }
        if (constraint instanceof PlanarConstraint) {
            return 2;
        }
        return 3;
    }

    public static ISnapConstraint intersect(PointConstraint lc1, PointConstraint lc2) throws NoIntersectionException {
        if (theUtil.eq0(lc1.p.distance(lc2.p), 1.0E-9)) {
            return lc1;
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(PointConstraint lc1, LineConstraint lc2) throws NoIntersectionException {
        if (theUtil.eq0(Inter3D.distSqToNearestPtOnLine(lc2.p, lc2.dir, lc1.p), 1.0E-12)) {
            return lc1;
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(PointConstraint lc1, PlanarConstraint lc2) throws NoIntersectionException {
        if (theUtil.eq0(lc2.plane.distance(lc1.p), 1.0E-9)) {
            return lc1;
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(LineConstraint lc1, LineConstraint lc2) throws NoIntersectionException {
        double dist;
        Vector3d dir2;
        Vector3d dir1 = Util3D.normalize(lc1.dir);
        if (theUtil.eq(Math.abs(dir1.dot(dir2 = Util3D.normalize(lc2.dir))), 1.0, 1.0E-9)) {
            if (theUtil.eq0(Inter3D.distSqToNearestPtOnLine(lc1.p, lc1.dir, lc2.p), 1.0E-12)) {
                return lc1;
            }
            throw new NoIntersectionException();
        }
        Point3d isect1 = new Point3d();
        Point3d isect2 = new Point3d();
        if (Inter3D.lineLineProximity(isect1, isect2, lc1.p, lc1.dir, lc2.p, lc2.dir) && theUtil.eq0(dist = isect1.distance(isect2), 1.0E-9)) {
            return new PointConstraint(isect1);
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(LineConstraint lc1, PlanarConstraint lc2) throws NoIntersectionException {
        Vector3d normal = lc2.plane.getNormal();
        if (theUtil.eq0(normal.dot(lc1.dir), 1.0E-9)) {
            if (theUtil.eq0(lc2.plane.distance(lc1.p), 1.0E-9)) {
                return lc1;
            }
            throw new NoIntersectionException();
        }
        Point3d isect = Inter3D.linePlaneIntersection(lc1.p, lc1.dir, lc2.plane, 1.0E-9);
        if (isect != null) {
            return new PointConstraint(isect);
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(PlanarConstraint lc1, PlanarConstraint lc2) throws NoIntersectionException {
        Vector3d norm2;
        Vector3d norm1 = lc1.plane.getNormal();
        if (theUtil.eq(Math.abs(norm1.dot(norm2 = lc2.plane.getNormal())), 1.0, 1.0E-9)) {
            if (theUtil.eq0(lc1.plane.distance(lc2.plane.getPointOnPlane()), 1.0E-9)) {
                return lc1;
            }
            throw new NoIntersectionException();
        }
        Tuple3d[] isect = Inter3D.planePlaneIsect(lc1.plane, lc2.plane, 1.0E-9);
        if (isect != null) {
            return new LineConstraint((Point3d)isect[0], (Vector3d)isect[1]);
        }
        throw new NoIntersectionException();
    }

    public static class NoIntersectionException
    extends Exception {
    }
}

