/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;

public class CompositeIsectFilter
implements IIsectFilter {
    public final IIsectFilter f1;
    public final IIsectFilter f2;
    public final Logic logic;

    public CompositeIsectFilter(IIsectFilter f1, IIsectFilter f2) {
        this(f1, f2, Logic.ACCEPT_ALL);
    }

    public CompositeIsectFilter(IIsectFilter f1, IIsectFilter f2, Logic logic) {
        this.f1 = f1;
        this.f2 = f2;
        this.logic = logic;
    }

    @Override
    public boolean acceptGeomType(Object source, GeomType type) {
        return this.logic == Logic.ACCEPT_ALL ? this.f1.acceptGeomType(source, type) && this.f2.acceptGeomType(source, type) : this.f1.acceptGeomType(source, type) || this.f2.acceptGeomType(source, type);
    }

    @Override
    public boolean acceptIntersection(IsectInfo info) {
        return this.logic == Logic.ACCEPT_ALL ? this.f1.acceptIntersection(info) && this.f2.acceptIntersection(info) : this.f1.acceptIntersection(info) || this.f2.acceptIntersection(info);
    }

    @Override
    public boolean acceptPickObject(Object obj) {
        return this.logic == Logic.ACCEPT_ALL ? this.f1.acceptPickObject(obj) && this.f2.acceptPickObject(obj) : this.f1.acceptPickObject(obj) || this.f2.acceptPickObject(obj);
    }

    @Override
    public boolean acceptPickObjType(Class type) {
        return this.logic == Logic.ACCEPT_ALL ? this.f1.acceptPickObjType(type) && this.f2.acceptPickObjType(type) : this.f1.acceptPickObjType(type) || this.f2.acceptPickObjType(type);
    }

    public static enum Logic {
        ACCEPT_ALL,
        ACCEPT_ANY;

    }
}

