/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.Point2d;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;

public class ZoomFunc
extends AToolFunction<CursorTool> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Zoom", "Zoom32.gif", 12, 12);
    public static final Icon ICON = guiUtil.loadTeciIcon("Zoom16.gif");
    private double d_mouseYLast;
    private Point2d d_zoomLoc;

    @Override
    public Cursor getCursor(CursorTool tool) {
        return CURSOR;
    }

    @Override
    public boolean isDrawable(CursorTool tool) {
        return false;
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
        this.d_zoomLoc = tool.getView().windowScreenToViewScreen(e.getPoint());
        this.d_mouseYLast = this.d_zoomLoc.y;
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseEntered(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseExited(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
        double mouseYCurr = tool.getP1().referenceSnapSc.y;
        if (this.d_mouseYLast == mouseYCurr) {
            return;
        }
        double dy = this.d_mouseYLast - mouseYCurr;
        double factor = dy * 3.0 / (double)tool.getView().getSurface().getWidth();
        factor = 1.0 / Math.pow(2.0, factor);
        tool.getView().zoom(factor);
        this.d_mouseYLast = mouseYCurr;
        tool.repaintSurface();
    }
}

