/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.ISelectionLogic;
import thunderheadeng.scene3d.navtools.ISelector;
import thunderheadeng.scene3d.picking.GeomPicker;

public class SelectionFunc
extends AToolFunction<CursorTool>
implements ISelector<CursorTool> {
    private final GeomPicker d_picker;
    private final ISelectionLogic d_selLogic;

    public SelectionFunc(GeomPicker picker, ISelectionLogic selLogic) {
        this.d_picker = picker;
        this.d_selLogic = selLogic;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public String getStatusMessage(CursorTool tool) {
        Point3d p = tool.getP1().constrained.isEmpty() ? tool.getP1().referenceSnap : tool.getP1().constrained.getLast();
        return tool.toString(p);
    }

    @Override
    public boolean showDragGuides(CursorTool tool) {
        return true;
    }

    @Override
    public boolean isDrawable(CursorTool tool) {
        return !(tool.getFunction() instanceof CompositeFunc);
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
        if (!tool.isDragging()) {
            if (!tool.dragAboveTolerance(1)) {
                this.select(tool, e);
            } else {
                this.selectMultiple(tool, e);
            }
        }
    }

    private boolean gridSelEnabled(CursorTool tool) {
        return tool.isKeyPressed(71);
    }

    @Override
    public Cursor getCursor(CursorTool tool) {
        return null;
    }

    @Override
    public void select(CursorTool tool, MouseEvent e) {
        Point2d viewPoint = tool.getView().windowScreenToViewScreen(e.getPoint());
        this.d_selLogic.selectSingle(tool, e, viewPoint, this.d_picker);
    }

    public void selectMultiple(CursorTool tool, MouseEvent e) {
        Point2d screenPoint1 = tool.getP0().referenceSnapSc;
        Point2d screenPoint2 = tool.getP1().referenceSnapSc;
        this.d_selLogic.selectMultiple(tool, e, screenPoint1, screenPoint2, this.d_picker);
    }
}

