/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.Intl;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.IKeyboardDevc;
import thunderheadeng.gui.tool.IMouseDevc;
import thunderheadeng.gui.tool.SwingMouse;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.ISelector;
import thunderheadeng.util.BitOptions;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.RWProp;
import thunderheadeng.util.time.WallClock;

public class RoamFunc<T extends CursorTool>
extends AToolFunction<T> {
    public static final int OPT_KEYBOARD = 1;
    public static final int OPT_MOUSE = 2;
    public static final int OPT_HTD = 4;
    public static final int OPT_ROAM_DEFAULT = 3;
    public static final RWProp<Integer> FORWARD = new RWProp<Integer>((Object)"FORWARD", 87);
    public static final RWProp<Integer> BACKWARD = new RWProp<Integer>((Object)"BACKWARD", 83);
    public static final RWProp<Integer> LEFT = new RWProp<Integer>((Object)"LEFT", 65);
    public static final RWProp<Integer> RIGHT = new RWProp<Integer>((Object)"RIGHT", 68);
    public static final RWProp<Integer> UP = new RWProp<Integer>((Object)"UP", 32);
    public static final RWProp<Integer> DOWN = new RWProp<Integer>((Object)"DOWN", 67);
    public static final RWProp<Integer> FASTER = new RWProp<Integer>((Object)"FASTER", 16);
    public static final List<RWProp<Integer>> MOVE_KEY_PROPS = Arrays.asList(FORWARD, BACKWARD, LEFT, RIGHT, UP, DOWN);
    public static final Cursor BLANK_CURSOR = guiUtil.createTeciCursor("Freelook", "blank16.gif", 15, 16);
    public static final Icon ICON = guiUtil.loadTeciIcon("running_man.gif");
    private final ISelector<T> d_selectionTool;
    private Robot d_robot;
    private Point d_lastMouseLoc = new Point(0, 0);
    private double d_pitch;
    private double d_roll;
    private double d_yaw;
    private Point3d d_loc = new Point3d();
    private double d_lastUpdateTime = -1.0;
    private boolean d_roamMode = false;
    private final PropertySet d_moveKeys = new PropertySet();
    private final Set<Integer> d_isMoveKey = new HashSet<Integer>();
    private final WallClock d_clock = new WallClock();
    private DragModeParams d_dragParams = new DragModeParams();
    private RoamModeParams d_roamParams = new RoamModeParams();
    private KBParams d_kbParams = new KBParams();
    private BitOptions d_options = new BitOptions(3L);
    private RoamPixelOffsets d_roamOffsets = new RoamPixelOffsets();
    private final SwingMouse d_mouse = new SwingMouse();
    private static final double PIXEL_TOL = 15.0;

    public RoamFunc(ISelector<T> selectionTool) {
        this.d_selectionTool = selectionTool;
        try {
            this.d_robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        this.d_clock.pause();
        this.updateMoveKeyMappings();
    }

    public void setKeyMapping(RWProp<Integer> movement, int keyCode) {
        this.d_moveKeys.setIfNotDefault(movement, keyCode);
    }

    public int getKeyMapping(RWProp<Integer> movement) {
        return this.d_moveKeys.get(movement);
    }

    private void updateMoveKeyMappings() {
        this.d_isMoveKey.clear();
        for (RWProp<Integer> mprop : MOVE_KEY_PROPS) {
            this.d_isMoveKey.add(this.d_moveKeys.get(mprop));
        }
    }

    private static int getMouseAnimateZBtn(boolean roamMode) {
        return 1;
    }

    private static int getMouseAnimateXBtn(boolean roamMode) {
        return 2;
    }

    private static int getMouseAnimateYBtn(boolean roamMode) {
        return 3;
    }

    public void setModelBounds(AABox modelBounds) {
        AABox workingModelBounds = new AABox(modelBounds);
        if (!workingModelBounds.isValid()) {
            workingModelBounds.ensureValidSize(5.0, 0.0);
        }
        double maxDist = workingModelBounds.getMin().distance(workingModelBounds.getMax());
        DragModeParams dragParams = this.getDragParams();
        RoamModeParams roamParams = this.getRoamParams();
        this.setRoamParams(roamParams);
        this.setDragParams(new DragModeParams(dragParams.orientSpeed, 0.001 * maxDist, 1.0));
    }

    public void setOptions(CursorTool tool, int options) {
        this.d_options = new BitOptions(options);
        if (this.d_options.getAny(4L)) {
            this.beginAnimation(tool);
        }
    }

    public int getOptions() {
        return (int)this.d_options.getRaw();
    }

    public KBParams getKeyboardParams() {
        return this.d_kbParams;
    }

    public void setKeyboardParams(KBParams params) {
        this.d_kbParams = params;
    }

    public DragModeParams getDragParams() {
        return this.d_dragParams;
    }

    public void setDragParams(DragModeParams params) {
        this.d_dragParams = params;
    }

    public RoamModeParams getRoamParams() {
        return this.d_roamParams;
    }

    public void setRoamParams(RoamModeParams params) {
        this.d_roamParams = params;
    }

    private void recordCameraState(T tool) {
        Camera c = ((CursorTool)tool).getView().getCamera();
        if (c == null) {
            return;
        }
        Camera.Position pos = c.getPositionInfo();
        Vector3d view = Util3D.vector(pos.pos, pos.ref);
        Vector3d up = pos.up;
        Vector3d y = new Vector3d(0.0, 1.0, 0.0);
        Vector3d xy = new Vector3d(view.x, view.y, 0.0);
        double yaw = y.angle(xy);
        Vector3d yawSign = Util3D.cross(y, xy);
        if (yawSign.z < 0.0) {
            yaw = -yaw;
        }
        if (Double.isNaN(yaw)) {
            yaw = 0.0;
        }
        Matrix4d axisAngle = Util.rotMat(0.0, 0.0, 1.0, -yaw);
        axisAngle.transform(view);
        Vector3d yz = new Vector3d(0.0, view.y, view.z);
        double pitch = y.angle(yz);
        Vector3d pitchSign = Util3D.cross(y, yz);
        if (pitchSign.x < 0.0) {
            pitch = -pitch;
        }
        if (Double.isNaN(pitch)) {
            pitch = 0.0;
        }
        axisAngle = Util.rotMat(1.0, 0.0, 0.0, -pitch);
        axisAngle.mul(Util.rotMat(0.0, 0.0, 1.0, -yaw));
        axisAngle.transform(up);
        Vector3d xz = new Vector3d(up.x, 0.0, up.z);
        double roll = GeomConstants.VEC3D_ZPOS.angle(xz);
        Vector3d rollSign = Util3D.cross(GeomConstants.VEC3D_ZPOS, xz);
        if (rollSign.y < 0.0) {
            roll = -roll;
        }
        if (Double.isNaN(roll)) {
            roll = 0.0;
        }
        this.d_yaw = yaw;
        this.d_pitch = pitch;
        this.d_roll = roll;
        this.d_loc = new Point3d(pos.pos);
    }

    private Quat4d calcOrient() {
        Quat4d orient = RoamFunc.newQuat(this.d_yaw, 0.0, 0.0, 1.0);
        orient.mul(RoamFunc.newQuat(this.d_pitch, 1.0, 0.0, 0.0));
        orient.mul(RoamFunc.newQuat(this.d_roll, 0.0, 1.0, 0.0));
        return orient;
    }

    private static void calcOrientVecs(Quat4d orient, Vector3d x, Vector3d y, Vector3d z) {
        Matrix4d xform = new Matrix4d();
        xform.set(orient);
        Matrix4d pxform = xform;
        if (x != null) {
            x.set(1.0, 0.0, 0.0);
            pxform.transform(x);
        }
        if (y != null) {
            y.set(0.0, 1.0, 0.0);
            pxform.transform(y);
        }
        if (z != null) {
            z.set(0.0, 0.0, 1.0);
            pxform.transform(z);
        }
    }

    private static Quat4d newQuat(double angle, double x, double y, double z) {
        Quat4d result = new Quat4d();
        result.set(new AxisAngle4d(x, y, z, angle));
        return result;
    }

    private void updateCameraState(T tool) {
        Point3d loc = this.d_loc;
        Quat4d rotation = this.calcOrient();
        Vector3d view = new Vector3d();
        Vector3d up = new Vector3d();
        RoamFunc.calcOrientVecs(rotation, null, view, up);
        Camera c = ((CursorTool)tool).getView().getCamera();
        c.setPositionInfo(new Camera.Position(loc, Util3D.add(loc, (Tuple3d)view), up));
        this.modified((CursorTool)tool);
    }

    @Override
    public void activate(T tool) {
        this.recordCameraState(tool);
    }

    private void modified(CursorTool tool) {
        if (tool != null) {
            tool.repaintSurface();
        }
    }

    private void beginAnimation(CursorTool tool) {
        if (!this.d_clock.isPaused()) {
            return;
        }
        tool.beginAnimation();
        this.d_lastUpdateTime = this.d_clock.resume();
        this.modified(tool);
    }

    private void endAnimation(CursorTool tool) {
        this.d_clock.pause();
        tool.endAnimation();
    }

    private boolean isKeyDown(CursorTool tool, int key) {
        return tool.getDevices().getKeyboard().isPressed(key);
    }

    private boolean isMouseButtonDown(CursorTool tool, IMouseDevc.Button mbutton) {
        return tool.getDevices().getMouse().isPressed(mbutton);
    }

    private boolean isLButtonDown(CursorTool tool) {
        return this.isMouseButtonDown(tool, IMouseDevc.Button.LEFT);
    }

    private boolean isMButtonDown(CursorTool tool) {
        return this.isMouseButtonDown(tool, IMouseDevc.Button.MIDDLE);
    }

    private boolean isRButtonDown(CursorTool tool) {
        return this.isMouseButtonDown(tool, IMouseDevc.Button.RIGHT);
    }

    private boolean getMouseAnimateMode(T tool) {
        return this.d_roamMode && (this.isLButtonDown((CursorTool)tool) || this.isRButtonDown((CursorTool)tool) || this.isMButtonDown((CursorTool)tool));
    }

    private boolean getMouseStaticMode(T tool) {
        return this.d_roamMode || this.isLButtonDown((CursorTool)tool) || this.isRButtonDown((CursorTool)tool) || this.isMButtonDown((CursorTool)tool);
    }

    private boolean getKeyboardAnimateMode(T tool) {
        for (RWProp<Integer> moveKey : MOVE_KEY_PROPS) {
            if (!this.isKeyDown((CursorTool)tool, this.d_moveKeys.get(moveKey))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(T tool, MouseEvent e) {
        this.d_lastMouseLoc = e.getPoint();
        if (this.getMouseAnimateMode(tool)) {
            this.beginAnimation((CursorTool)tool);
        }
    }

    private Camera getCamera(T tool) {
        return ((CursorTool)tool).getView().getCamera();
    }

    @Override
    public void mouseReleased(T tool, MouseEvent e) {
        if (!((CursorTool)tool).dragAboveTolerance(0)) {
            if (SwingMouse.getPredef(e) == IMouseDevc.Button.MIDDLE) {
                this.d_roamMode = !this.d_roamMode;
            } else if (!this.d_roamMode && this.d_selectionTool != null) {
                this.d_selectionTool.select(tool, e);
            }
        }
        this.setCursorVisible(tool, !this.getHideCursor());
        if (this.getMouseAnimateMode(tool)) {
            IMouseDevc.Button btn = SwingMouse.getPredef(e);
            if (btn != null) {
                switch (btn) {
                    case LEFT: {
                        this.d_roamOffsets.localX = 0;
                        break;
                    }
                    case RIGHT: {
                        this.d_roamOffsets.localY = 0;
                    }
                }
            }
            if (!this.isLButtonDown((CursorTool)tool) && !this.isMButtonDown((CursorTool)tool)) {
                this.d_roamOffsets.localZ = 0;
            }
            if (!this.isMButtonDown((CursorTool)tool) && !this.isRButtonDown((CursorTool)tool)) {
                this.d_roamOffsets.zturn = 0;
            }
        } else {
            this.d_roamOffsets = new RoamPixelOffsets();
        }
    }

    private void setCursorVisible(T tool, boolean visible) {
        if (visible) {
            ((CursorTool)tool).restoreSystemCursor();
        } else {
            ((CursorTool)tool).getAttachedComponent().setCursor(BLANK_CURSOR);
        }
    }

    private boolean getHideCursor() {
        return this.d_roamMode;
    }

    @Override
    public void keyPressed(T tool, KeyEvent e) {
        if (this.d_isMoveKey.contains(e.getKeyCode())) {
            this.beginAnimation((CursorTool)tool);
        } else {
            switch (e.getKeyCode()) {
                case 27: {
                    this.d_roamMode = false;
                    this.setCursorVisible(tool, !this.getHideCursor());
                    this.modified((CursorTool)tool);
                }
            }
        }
    }

    @Override
    public void keyReleased(T tool, KeyEvent e) {
    }

    private static double adjustForTol(double val, double tol) {
        double aval = Math.abs(val);
        if (aval > tol) {
            double sign = val < 0.0 ? -1.0 : 1.0;
            return sign * (aval - tol);
        }
        return 0.0;
    }

    private Object getInUseHTD(T tool) {
        return null;
    }

    @Override
    public boolean animate(T tool, IAnimSession session) {
        if (this.getCamera(tool) == null) {
            return false;
        }
        double time = this.d_clock.getTime();
        double dt = time - this.d_lastUpdateTime;
        Quat4d orient = this.calcOrient();
        if (this.getKeyboardAnimateMode(tool)) {
            IKeyboardDevc keyboard = ((CursorTool)tool).getDevices().getKeyboard();
            boolean movef = keyboard.isPressed(this.d_moveKeys.get(FORWARD));
            boolean moveb = keyboard.isPressed(this.d_moveKeys.get(BACKWARD));
            boolean strafel = keyboard.isPressed(this.d_moveKeys.get(LEFT));
            boolean strafer = keyboard.isPressed(this.d_moveKeys.get(RIGHT));
            boolean moveu = keyboard.isPressed(this.d_moveKeys.get(UP));
            boolean moved = keyboard.isPressed(this.d_moveKeys.get(DOWN));
            boolean speed = keyboard.isPressed(this.d_moveKeys.get(FASTER));
            double moveVel = !speed ? this.d_kbParams.getSpeed() : this.d_kbParams.getSpeed() * 2.0;
            double moveDist = moveVel * dt;
            Vector3d moveVec = new Vector3d();
            if (moveu) {
                moveVec.z += moveDist;
            }
            if (moved) {
                moveVec.z -= moveDist;
            }
            if (strafel || strafer) {
                Vector3d rightVec = new Vector3d();
                RoamFunc.calcOrientVecs(orient, rightVec, null, null);
                rightVec.normalize();
                rightVec.scale(moveDist);
                Vector3d right = new Vector3d();
                if (strafer) {
                    right.add((Tuple3d)rightVec);
                }
                if (strafel) {
                    right.sub((Tuple3d)rightVec);
                }
                moveVec.add((Tuple3d)right);
            }
            if (movef || moveb) {
                Vector3d forwardVec = new Vector3d();
                RoamFunc.calcOrientVecs(orient, null, forwardVec, null);
                forwardVec.normalize();
                forwardVec.scale(moveDist);
                Vector3d forward = new Vector3d();
                if (movef) {
                    forward.add((Tuple3d)forwardVec);
                }
                if (moveb) {
                    forward.sub((Tuple3d)forwardVec);
                }
                moveVec.add((Tuple3d)forward);
            }
            this.d_loc.add((Tuple3d)moveVec);
        } else if (this.getMouseAnimateMode(tool)) {
            Vector3d right;
            double moveDist;
            double turnDistPx = RoamFunc.adjustForTol(this.d_roamOffsets.zturn, 15.0);
            double xDistPx = RoamFunc.adjustForTol(this.d_roamOffsets.localX, 15.0);
            double yDistPx = RoamFunc.adjustForTol(this.d_roamOffsets.localY, 15.0);
            double zDistPx = RoamFunc.adjustForTol(this.d_roamOffsets.localZ, 15.0);
            if (turnDistPx != 0.0) {
                double dvTurn = dt * this.d_roamParams.turnAccel;
                double turnAngle = -turnDistPx * dvTurn;
                this.d_yaw += turnAngle;
            }
            double dvMove = dt * this.d_roamParams.moveAccel;
            Vector3d moveVec = new Vector3d();
            if (xDistPx != 0.0) {
                moveDist = xDistPx * dvMove;
                right = new Vector3d();
                RoamFunc.calcOrientVecs(orient, right, null, null);
                right.normalize();
                right.scale(moveDist);
                moveVec.add((Tuple3d)right);
            }
            if (zDistPx != 0.0) {
                moveDist = -zDistPx * dvMove;
                right = new Vector3d();
                RoamFunc.calcOrientVecs(orient, right, null, null);
                Vector3d xyVec = Util3D.cross(GeomConstants.VEC3D_ZPOS, right);
                xyVec.normalize();
                xyVec.scale(moveDist);
                moveVec.add((Tuple3d)xyVec);
            }
            if (yDistPx != 0.0) {
                double zdist = -yDistPx * dvMove;
                moveVec.z += zdist;
            }
            this.d_loc.add((Tuple3d)moveVec);
        } else if (this.getInUseHTD(tool) == null) {
            this.endAnimation((CursorTool)tool);
        }
        this.updateCameraState(tool);
        this.d_lastUpdateTime = time;
        return this.d_clock.isPaused() && this.getInUseHTD(tool) == null;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public boolean isDrawable(T tool) {
        return false;
    }

    @Override
    public boolean enableZoomAboutPoint(T tool) {
        return false;
    }

    @Override
    public Cursor getCursor(T tool) {
        return Cursor.getPredefinedCursor(0);
    }

    @Override
    public void mouseWheelMoved(T tool, MouseWheelEvent e) {
        if (((CursorTool)tool).getPressedKeys().contains(17)) {
            double rotation = -e.getPreciseWheelRotation() * 0.2;
            double newFactor = Math.pow(2.0, rotation);
            this.d_dragParams = new DragModeParams(this.d_dragParams.orientSpeed, this.d_dragParams.moveSpeed, this.d_dragParams.moveFactor * newFactor);
            this.d_kbParams = new KBParams(this.d_kbParams.speed, this.d_kbParams.factor * newFactor);
            ((CursorTool)tool).updateStatusMessage();
        } else {
            super.mouseWheelMoved(tool, e);
        }
    }

    @Override
    public void mouseMoved(T tool, MouseEvent e) {
        this.respondToMouse(tool, e);
    }

    @Override
    public void mouseDragged(T tool, MouseEvent e) {
        this.respondToMouse(tool, e);
    }

    public void respondToMouse(T tool, MouseEvent e) {
        this.recordCameraState(tool);
        Point mousePos = e.getPoint();
        int dx = mousePos.x - this.d_lastMouseLoc.x;
        int dy = mousePos.y - this.d_lastMouseLoc.y;
        if (this.d_roamMode) {
            if (this.d_robot != null) {
                Point windowLocation = ((CursorTool)tool).getAttachedComponent().getLocationOnScreen();
                this.d_robot.mouseMove(windowLocation.x + this.d_lastMouseLoc.x, windowLocation.y + this.d_lastMouseLoc.y);
            }
        } else {
            this.d_lastMouseLoc = e.getPoint();
        }
        if (this.getMouseAnimateMode(tool)) {
            IMouseDevc mouse = ((CursorTool)tool).getDevices().getMouse();
            IMouseDevc.Button latestBtn = mouse.getMostRecentlyPressedPredef(Stream.of(IMouseDevc.Button.LEFT, IMouseDevc.Button.MIDDLE, IMouseDevc.Button.RIGHT));
            if (latestBtn != null) {
                switch (latestBtn) {
                    case LEFT: {
                        this.d_roamOffsets.localX += dx;
                        this.d_roamOffsets.localZ += dy;
                        break;
                    }
                    case MIDDLE: {
                        this.d_roamOffsets.zturn += dx;
                        this.d_roamOffsets.localZ += dy;
                        break;
                    }
                    default: {
                        this.d_roamOffsets.zturn += dx;
                        this.d_roamOffsets.localY += dy;
                    }
                }
            }
        } else if (this.getCamera(tool) != null && this.getMouseStaticMode(tool)) {
            boolean shouldOrbit;
            boolean shouldTranslateVert = false;
            boolean shouldTranslateForward = false;
            boolean shouldTranslateRight = false;
            if (!this.d_roamMode) {
                shouldTranslateRight = shouldTranslateForward = this.isKeyDown((CursorTool)tool, 17) && this.isLButtonDown((CursorTool)tool) || this.isMButtonDown((CursorTool)tool);
                shouldTranslateVert = this.isKeyDown((CursorTool)tool, 18) && this.isLButtonDown((CursorTool)tool) || this.isRButtonDown((CursorTool)tool);
            }
            boolean shouldTranslate = shouldTranslateForward || shouldTranslateRight || shouldTranslateVert;
            boolean bl = shouldOrbit = !shouldTranslate;
            if (shouldTranslate) {
                Quat4d orient = this.calcOrient();
                double speed = this.d_dragParams.getMovementSpeed();
                double paramX = (double)dx * speed;
                double paramY = (double)dy * -speed;
                Vector3d moveVec = new Vector3d();
                if (shouldTranslateVert) {
                    moveVec.add((Tuple3d)new Vector3d(0.0, 0.0, paramY));
                }
                if (shouldTranslateForward) {
                    Vector3d right = new Vector3d();
                    RoamFunc.calcOrientVecs(orient, right, null, null);
                    Vector3d forward = Util3D.cross(GeomConstants.VEC3D_ZPOS, right);
                    if (Util3D.safeNormalize(forward, 1.0E-9) == 0.0) {
                        RoamFunc.calcOrientVecs(orient, null, forward, null);
                    }
                    forward.scale(paramY);
                    moveVec.add((Tuple3d)forward);
                }
                if (shouldTranslateRight) {
                    Vector3d forward = new Vector3d();
                    RoamFunc.calcOrientVecs(orient, null, forward, null);
                    Vector3d right = Util3D.cross(forward, GeomConstants.VEC3D_ZPOS);
                    if (Util3D.safeNormalize(right, 1.0E-9) == 0.0) {
                        RoamFunc.calcOrientVecs(orient, right, null, null);
                    }
                    right.scale(paramX);
                    moveVec.add((Tuple3d)right);
                }
                this.d_loc.add((Tuple3d)moveVec);
            }
            if (shouldOrbit) {
                double speed = this.d_dragParams.orientSpeed;
                this.d_pitch -= (double)dy * speed;
                this.d_yaw -= (double)dx * speed;
                this.d_roll = 0.0;
                double PI2d = Math.PI * 2;
                double overRotX = this.d_pitch / (Math.PI * 2);
                if (overRotX > 1.0) {
                    this.d_pitch = (overRotX - Math.floor(overRotX)) * (Math.PI * 2);
                } else if (overRotX < -1.0) {
                    this.d_pitch = (overRotX - Math.ceil(overRotX)) * (Math.PI * 2);
                }
                double overRotY = this.d_yaw / (Math.PI * 2);
                if (overRotY > 1.0) {
                    this.d_yaw = (overRotY - Math.floor(overRotY)) * (Math.PI * 2);
                } else if (overRotY < -1.0) {
                    this.d_yaw = (overRotY - Math.ceil(overRotY)) * (Math.PI * 2);
                }
                double angleLimitR = 1.5707963267948966 - Math.toRadians(1.0);
                if (this.d_pitch > angleLimitR) {
                    this.d_pitch = angleLimitR;
                } else if (this.d_pitch < -angleLimitR) {
                    this.d_pitch = -angleLimitR;
                }
            }
            this.updateCameraState(tool);
        }
    }

    @Override
    public String getStatusMessage(T tool) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(String.format(Intl.intl("Movement Speed Factor: %s (Ctrl+scroll wheel to change)"), ((CursorTool)tool).format(this.d_dragParams.moveFactor)));
        messages.add(Intl.intl("Click-drag to look"));
        messages.add(String.format(Intl.intl("[%1$s][%2$s][%3$s][%4$s] to move"), KeyEvent.getKeyText(this.d_moveKeys.get(FORWARD)), KeyEvent.getKeyText(this.d_moveKeys.get(BACKWARD)), KeyEvent.getKeyText(this.d_moveKeys.get(LEFT)), KeyEvent.getKeyText(this.d_moveKeys.get(RIGHT))));
        messages.add(String.format(Intl.intl("[%s] to move down"), KeyEvent.getKeyText(this.d_moveKeys.get(DOWN))));
        messages.add(String.format(Intl.intl("[%s] to move up"), KeyEvent.getKeyText(this.d_moveKeys.get(UP))));
        return String.join((CharSequence)"; ", messages);
    }

    private static class RoamPixelOffsets {
        public int zturn = 0;
        public int localX = 0;
        public int localY = 0;
        public int localZ = 0;

        private RoamPixelOffsets() {
        }
    }

    public static class KBParams {
        public final double speed;
        public final double factor;

        public KBParams() {
            this(4.0, 1.0);
        }

        public KBParams(double speed, double factor) {
            this.speed = speed;
            this.factor = factor;
        }

        public double getSpeed() {
            return this.speed * this.factor;
        }
    }

    public static class RoamModeParams {
        public final double turnAccel;
        public final double moveAccel;

        public RoamModeParams() {
            this(0.001, 0.05);
        }

        public RoamModeParams(double turnAccel, double moveAccel) {
            this.turnAccel = turnAccel;
            this.moveAccel = moveAccel;
        }
    }

    public static class DragModeParams {
        public final double orientSpeed;
        public final double moveSpeed;
        public final double moveFactor;

        public DragModeParams() {
            this(0.003, 0.001, 1.0);
        }

        public DragModeParams(double orientSpeed, double moveSpeed, double moveFactor) {
            this.orientSpeed = orientSpeed;
            this.moveSpeed = moveSpeed;
            this.moveFactor = moveFactor;
        }

        public double getMovementSpeed() {
            return this.moveSpeed * this.moveFactor;
        }
    }
}

