/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.ISelector;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.ManipFunc;
import thunderheadeng.scene3d.navtools.SelectionFunc;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public class MultiFunc
extends AToolFunction<CursorTool> {
    private static final int PAN_BTN = 2;
    private static final int ORBIT_BTN = 3;
    private final IToolFunction<CursorTool> d_orbit;
    private final IToolFunction<CursorTool> d_pan;
    private final ManipFunc d_manip;
    private final SelectionFunc d_select;
    private final List<IToolFunction<CursorTool>> d_allFuncs;
    private Mode d_mode;
    private boolean t_panned = false;
    private boolean t_orbited = false;

    public MultiFunc(SelectionFunc select, IToolFunction<CursorTool> orbitFunc, IToolFunction<CursorTool> dragFunc) {
        this(null, select, orbitFunc, dragFunc);
    }

    public MultiFunc(ManipFunc manip, SelectionFunc select, IToolFunction<CursorTool> orbitFunc, IToolFunction<CursorTool> dragFunc) {
        this.d_manip = manip;
        this.d_select = select;
        this.d_orbit = orbitFunc;
        this.d_pan = dragFunc;
        this.d_mode = Mode.SELECT;
        this.d_allFuncs = new ArrayList<IToolFunction<CursorTool>>();
        if (this.d_manip != null) {
            this.d_allFuncs.add(this.d_manip);
        }
        this.d_allFuncs.add(this.d_select);
        if (this.d_pan != null) {
            this.d_allFuncs.add(this.d_pan);
        }
        if (this.d_orbit != null) {
            this.d_allFuncs.add(this.d_orbit);
        }
    }

    public IToolFunction<CursorTool> getActiveFunc(CursorTool tool) {
        if (tool.isDragging(2) && this.d_pan != null) {
            return this.d_pan;
        }
        if (tool.isDragging(3) && this.d_orbit != null) {
            return this.d_orbit;
        }
        switch (this.d_mode) {
            case MANIP: {
                return this.d_manip;
            }
        }
        return this.d_select;
    }

    public void select(CursorTool tool, MouseEvent evt) {
        if (this.getActiveFunc(tool) instanceof ISelector) {
            ((ISelector)((Object)this.getActiveFunc(tool))).select(tool, evt);
        }
    }

    @Override
    public Cursor getCursor(CursorTool tool) {
        return this.getActiveFunc(tool).getCursor(tool);
    }

    @Override
    public void activate(CursorTool tool) {
        tool.setCancelOnRightClick(false);
        for (IToolFunction<CursorTool> func : this.d_allFuncs) {
            func.activate(tool);
        }
    }

    @Override
    public void deactivate(CursorTool tool) {
        for (IToolFunction<CursorTool> func : this.d_allFuncs) {
            func.deactivate(tool);
        }
    }

    @Override
    public void cancel(CursorTool tool) {
        this.t_panned = false;
        this.t_orbited = false;
        for (IToolFunction<CursorTool> func : this.d_allFuncs) {
            func.cancel(tool);
        }
        this.d_mode = Mode.SELECT;
    }

    @Override
    public boolean isDrawable(CursorTool tool) {
        return this.getActiveFunc(tool).isDrawable(tool);
    }

    @Override
    public boolean showDragGuides(CursorTool tool) {
        return this.getActiveFunc(tool).showDragGuides(tool);
    }

    @Override
    public boolean enableZoomAboutPoint(CursorTool tool) {
        return true;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public Pair<SnapMode, IIsectFilter> getSnapInfo(CursorTool tool) {
        return this.getActiveFunc(tool).getSnapInfo(tool);
    }

    @Override
    public ISnapConstraint getDefaultConstraint(CursorTool tool) {
        return this.getActiveFunc(tool).getDefaultConstraint(tool);
    }

    @Override
    public ISnapConstraint getSnapConstraint(CursorTool tool) {
        return this.getActiveFunc(tool).getSnapConstraint(tool);
    }

    @Override
    public void keyPressed(CursorTool tool, KeyEvent e) {
        for (IToolFunction<CursorTool> func : this.d_allFuncs) {
            func.keyPressed(tool, e);
        }
    }

    @Override
    public void keyReleased(CursorTool tool, KeyEvent e) {
        for (IToolFunction<CursorTool> func : this.d_allFuncs) {
            func.keyReleased(tool, e);
        }
    }

    @Override
    public void mouseEntered(CursorTool tool, MouseEvent e) {
        for (IToolFunction<CursorTool> func : this.d_allFuncs) {
            func.mouseEntered(tool, e);
        }
    }

    @Override
    public void mouseExited(CursorTool tool, MouseEvent e) {
        for (IToolFunction<CursorTool> func : this.d_allFuncs) {
            func.mouseExited(tool, e);
        }
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
        for (IToolFunction<CursorTool> func : this.d_allFuncs) {
            func.mouseMoved(tool, e);
        }
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.d_manip != null && !tool.isKeyPressed(18)) {
                this.d_manip.mousePressed(tool, e);
            }
            if (this.d_manip != null && this.d_manip.isManipulating()) {
                this.d_mode = Mode.MANIP;
            } else {
                this.d_mode = Mode.SELECT;
                this.d_select.mousePressed(tool, e);
            }
        } else if (e.getButton() == 2 && this.d_pan != null) {
            this.d_pan.mousePressed(tool, e);
        } else if (e.getButton() == 3 && this.d_orbit != null) {
            this.d_orbit.mousePressed(tool, e);
        }
        if (e.getButton() == 3 && this.d_mode == Mode.SELECT) {
            this.d_select.mousePressed(tool, e);
        }
        this.updateToolDisplay(tool);
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
        IToolFunction<CursorTool> func = this.getActiveFunc(tool);
        func.mouseDragged(tool, e);
        this.t_panned |= func == this.d_pan && tool.isDragging(2);
        this.t_orbited |= func == this.d_orbit && tool.isDragging(3);
        this.updateToolDisplay(tool);
    }

    protected void updateToolDisplay(CursorTool tool) {
        tool.updateMouseProps();
        tool.showToolCursor();
        tool.markNativeDirty();
        tool.repaintSurface();
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
        boolean panned = this.t_panned;
        boolean orbited = this.t_orbited;
        if (e.getButton() == 2 && this.d_pan != null) {
            this.d_pan.mouseReleased(tool, e);
            this.t_panned = false;
        } else if (e.getButton() == 3 && this.d_orbit != null) {
            this.d_orbit.mouseReleased(tool, e);
            this.t_orbited = false;
        }
        if (this.d_mode == Mode.SELECT) {
            if (e.getButton() == 1 || e.getButton() == 3 && !orbited && !panned) {
                this.d_select.mouseReleased(tool, e);
            }
        } else if (this.d_mode == Mode.MANIP) {
            assert (this.d_manip != null);
            if (e.getButton() == 1 && e.getClickCount() > 1) {
                this.d_manip.cancel(tool);
                this.d_mode = Mode.SELECT;
                this.d_select.mouseReleased(tool, e);
            } else if (e.getButton() == 3 && !orbited && !panned) {
                this.d_manip.cancel(tool);
                this.d_mode = Mode.SELECT;
            } else if (e.getButton() == 1) {
                this.d_manip.mouseReleased(tool, e);
                if (!this.d_manip.isManipulating()) {
                    this.d_mode = Mode.SELECT;
                }
            }
        }
        this.updateToolDisplay(tool);
    }

    @Override
    public String getStatusMessage(CursorTool tool) {
        return this.getActiveFunc(tool).getStatusMessage(tool);
    }

    private static enum Mode {
        MANIP,
        SELECT;

    }
}

