/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;

public class DragFunc
extends AToolFunction<CursorTool> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Drag", "DRAG.gif", 15, 15);
    public static final Icon ICON = guiUtil.loadTeciIcon("drag16.gif");
    private Point3d d_iniPickPos;

    @Override
    public Cursor getCursor(CursorTool tool) {
        return CURSOR;
    }

    @Override
    public boolean isDrawable(CursorTool tool) {
        return false;
    }

    private Point3d getPickPos(CursorTool tool) {
        Camera c = tool.getView().getCamera();
        Plane3d refPlane = c.getRefPlane();
        CursorTool.Ray pickRay = tool.getPickRay();
        return Inter3D.linePlaneIntersection(pickRay.begin, pickRay.dir, refPlane, 1.0E-9);
    }

    @Override
    public void mousePressed(CursorTool tool, MouseEvent e) {
        this.d_iniPickPos = this.getPickPos(tool);
    }

    @Override
    public void mouseDragged(CursorTool tool, MouseEvent e) {
        Point3d newPickPos = this.getPickPos(tool);
        if (this.d_iniPickPos == null || newPickPos == null) {
            return;
        }
        Vector3d moveDir = new Vector3d();
        moveDir.sub((Tuple3d)this.d_iniPickPos, (Tuple3d)newPickPos);
        Camera c = tool.getView().getCamera();
        c.translateWorld(moveDir, true);
        tool.repaintSurface();
    }

    @Override
    public void mouseReleased(CursorTool tool, MouseEvent e) {
    }

    @Override
    public void mouseMoved(CursorTool tool, MouseEvent e) {
    }
}

