/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;

public class CompositeFunc<T extends CursorTool>
extends AToolFunction<T> {
    public static final int NULL_EVENT_MOVE = 0;
    public static final int NULL_EVENT_GESTURE = 1;
    public static final int NULL_EVENT_CLICK = 2;
    public static final int ALT_EVENT_MOVE = 3;
    public static final int ALT_EVENT_GESTURE = 4;
    public static final int ALT_EVENT_CLICK = 5;
    public static final int SHIFT_EVENT_MOVE = 6;
    public static final int SHIFT_EVENT_GESTURE = 7;
    public static final int SHIFT_EVENT_CLICK = 8;
    private final IToolFunction d_defaultTool;
    private final Map<Integer, IToolFunction> d_eventToolMap = new LinkedHashMap<Integer, IToolFunction>();
    private IToolFunction d_currentTool;

    public CompositeFunc() {
        this.d_defaultTool = new DefaultTool();
        this.d_currentTool = this.d_defaultTool;
    }

    @Override
    public void cancel(T tool) {
        ArrayList<IToolFunction> cancelledFuncs = new ArrayList<IToolFunction>();
        for (IToolFunction func : this.d_eventToolMap.values()) {
            if (cancelledFuncs.contains(func)) continue;
            func.cancel(tool);
            cancelledFuncs.add(func);
        }
    }

    public IToolFunction getCurrentFunc() {
        return this.d_currentTool;
    }

    @Override
    public void activate(T tool) {
        this.setToMove((CursorTool)tool, 0);
    }

    public void setEventTool(int event, IToolFunction tool) {
        if (tool == null) {
            tool = this.d_defaultTool;
        }
        this.d_eventToolMap.put(event, tool);
    }

    public void setToolEvents(IToolFunction tool, int ... events) {
        for (int evt : events) {
            this.setEventTool(evt, tool);
        }
    }

    @Override
    public boolean showDragGuides(T tool) {
        return this.d_currentTool.showDragGuides(tool);
    }

    @Override
    public boolean isDrawable(T tool) {
        IToolFunction func = this.d_currentTool;
        return func != null ? func.isDrawable(tool) : false;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return this.d_eventToolMap.get(5) == null && this.d_eventToolMap.get(4) == null && this.d_eventToolMap.get(3) == null;
    }

    @Override
    public Cursor getCursor(T tool) {
        return this.d_currentTool.getCursor(tool);
    }

    private boolean shiftPressed(int eventModifiers) {
        return (eventModifiers & 0x40) == 64;
    }

    private boolean altPressed(int eventModifiers) {
        return (eventModifiers & 0x200) == 512;
    }

    private void setToMove(CursorTool tool, int modifiers) {
        IToolFunction newTool = null;
        newTool = this.shiftPressed(modifiers) ? this.d_eventToolMap.get(6) : (this.altPressed(modifiers) ? this.d_eventToolMap.get(3) : this.d_eventToolMap.get(0));
        this.setCurrentTool(tool, newTool);
    }

    private MouseEvent newMouseEvent(CursorTool tool, KeyEvent e, int event) {
        int pressedBtn = tool.getPressedButtons().isEmpty() ? 0 : tool.getPressedButtons().iterator().next();
        Point2d loc = tool.getView().viewScreenToWindowScreen(tool.getP1().referenceSnapSc);
        MouseEvent evt = new MouseEvent(e.getComponent(), event, e.getWhen(), e.getModifiersEx(), (int)loc.x, (int)loc.y, 1, false, pressedBtn);
        return evt;
    }

    private void updateKeyEvent(CursorTool tool, KeyEvent e) {
        if (tool.isDragging()) {
            IToolFunction newTool = null;
            newTool = this.shiftPressed(e.getModifiersEx()) ? this.d_eventToolMap.get(7) : (this.altPressed(e.getModifiersEx()) ? this.d_eventToolMap.get(4) : this.d_eventToolMap.get(1));
            if (newTool == this.d_currentTool) {
                return;
            }
            MouseEvent evt = this.newMouseEvent(tool, e, 502);
            this.d_currentTool.mouseReleased(tool, evt);
            this.setCurrentTool(tool, newTool);
            evt = this.newMouseEvent(tool, e, 501);
            this.d_currentTool.mousePressed(tool, evt);
        } else {
            IToolFunction newTool = null;
            newTool = this.shiftPressed(e.getModifiersEx()) ? this.d_eventToolMap.get(6) : (this.altPressed(e.getModifiersEx()) ? this.d_eventToolMap.get(3) : this.d_eventToolMap.get(0));
            if (newTool == this.d_currentTool) {
                return;
            }
            this.setCurrentTool(tool, newTool);
            MouseEvent evt = this.newMouseEvent(tool, e, 503);
            this.d_currentTool.mouseMoved(tool, evt);
        }
    }

    @Override
    public void keyPressed(T tool, KeyEvent e) {
        this.updateKeyEvent((CursorTool)tool, e);
    }

    @Override
    public void keyReleased(T tool, KeyEvent e) {
        this.updateKeyEvent((CursorTool)tool, e);
    }

    @Override
    public void mousePressed(T tool, MouseEvent e) {
        IToolFunction newTool = null;
        newTool = this.shiftPressed(e.getModifiersEx()) ? this.d_eventToolMap.get(7) : (this.altPressed(e.getModifiersEx()) ? this.d_eventToolMap.get(4) : this.d_eventToolMap.get(1));
        this.setCurrentTool((CursorTool)tool, newTool);
        this.d_currentTool.mousePressed(tool, e);
    }

    @Override
    public void mouseMoved(T tool, MouseEvent e) {
        this.d_currentTool.mouseMoved(tool, e);
        this.updateCursor((CursorTool)tool);
    }

    @Override
    public void mouseDragged(T tool, MouseEvent e) {
        this.d_currentTool.mouseDragged(tool, e);
        this.updateCursor((CursorTool)tool);
    }

    @Override
    public void mouseReleased(T tool, MouseEvent e) {
        this.d_currentTool.mouseReleased(tool, e);
        if (!((CursorTool)tool).dragAboveTolerance(0)) {
            IToolFunction currTool = this.d_currentTool;
            IToolFunction clickTool = null;
            clickTool = this.shiftPressed(e.getModifiersEx()) ? this.d_eventToolMap.get(8) : (this.altPressed(e.getModifiersEx()) ? this.d_eventToolMap.get(5) : this.d_eventToolMap.get(2));
            if (clickTool != null) {
                this.setCurrentTool((CursorTool)tool, clickTool, false);
                clickTool.mousePressed(tool, e);
                clickTool.mouseReleased(tool, e);
                this.setCurrentTool((CursorTool)tool, currTool);
            }
        }
        this.setToMove((CursorTool)tool, e.getModifiersEx());
        this.updateCursor((CursorTool)tool);
    }

    public void setCurrentTool(CursorTool ct, IToolFunction tool) {
        this.setCurrentTool(ct, tool, true);
    }

    public void setCurrentTool(CursorTool ct, IToolFunction tool, boolean updateCursor) {
        if (tool == this.d_currentTool) {
            return;
        }
        if (tool == null) {
            tool = this.d_defaultTool;
        }
        this.d_currentTool = tool;
        if (updateCursor) {
            this.updateCursor(ct);
        }
        ct.markNativeDirty();
        ct.repaintSurface();
    }

    private void updateCursor(CursorTool tool) {
        Cursor cursor = this.d_currentTool.getCursor(tool);
        tool.setToolCursor(cursor);
        tool.showToolCursor();
    }

    @Override
    public void mouseEntered(T tool, MouseEvent e) {
        this.d_currentTool.mouseEntered(tool, e);
    }

    @Override
    public void mouseExited(T tool, MouseEvent e) {
        this.d_currentTool.mouseExited(tool, e);
    }

    private static class DefaultTool<T extends CursorTool>
    extends AToolFunction<T> {
        @Override
        public Cursor getCursor(T tool) {
            return null;
        }

        public boolean areGuidesVisible(CursorTool tool) {
            return false;
        }

        @Override
        public boolean isDrawable(T tool) {
            return false;
        }

        @Override
        public boolean showDragGuides(T tool) {
            return false;
        }

        @Override
        public void mouseDragged(T tool, MouseEvent e) {
        }

        @Override
        public void mouseMoved(T tool, MouseEvent e) {
        }

        @Override
        public void mousePressed(T tool, MouseEvent e) {
        }

        @Override
        public void mouseReleased(T tool, MouseEvent e) {
        }

        @Override
        public void mouseEntered(T tool, MouseEvent e) {
        }

        @Override
        public void mouseExited(T tool, MouseEvent e) {
        }
    }
}

