/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Point;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.Scene;

public class View {
    private final Supplier<Camera> d_scene;
    private final IRenderSurface d_surface;

    public View(IRenderSurface surface, Scene scene) {
        this(surface, () -> scene.getCamera());
    }

    public View(IRenderSurface surface, Supplier<Camera> camera) {
        this.d_scene = camera;
        this.d_surface = surface;
    }

    public Camera getCamera() {
        return this.d_scene.get();
    }

    public IRenderSurface getSurface() {
        return this.d_surface;
    }

    public void zoomAboutPoint(double factor, Point2d zoomPointScreen) {
        Point3d zoomPointCam3d = this.screenToCamera(new Point3d(zoomPointScreen.x, zoomPointScreen.y, 0.0));
        Point2d zoomPointCam2d = new Point2d(zoomPointCam3d.x, zoomPointCam3d.y);
        this.updateLayout();
        this.getCamera().zoomAboutPoint(factor, zoomPointCam2d);
    }

    public void zoom(double factor, Point2d zoomCenterScreen) {
        Point3d zoomCenterCam3d = this.screenToCamera(new Point3d(zoomCenterScreen.x, zoomCenterScreen.y, 0.0));
        Point2d zoomCenterCam2d = new Point2d(zoomCenterCam3d.x, zoomCenterCam3d.y);
        this.updateLayout();
        this.getCamera().zoom(factor, zoomCenterCam2d);
    }

    public void zoom(double factor) {
        double width = this.getSurface().getWidth();
        double height = this.getSurface().getHeight();
        this.updateLayout();
        this.zoom(factor, new Point2d(width * 0.5, height * 0.5));
    }

    public double calcScreenZValue(double distFromCamera) {
        this.updateLayout();
        return this.d_scene.get().calcScreenZValue(distFromCamera);
    }

    public Point3d constrainPointToView(Point3d refPoint, Point3d desiredLocation) {
        this.updateLayout();
        return this.d_scene.get().constrainPointToView(refPoint, desiredLocation);
    }

    public Point3d worldToView(Point3d world) {
        this.updateLayout();
        return this.d_scene.get().worldToView(world);
    }

    public Point4d worldToView(Point4d world) {
        this.updateLayout();
        return this.d_scene.get().worldToView(world);
    }

    public Point3d viewToWorld(Point3d view) {
        this.updateLayout();
        return this.d_scene.get().viewToWorld(view);
    }

    public Point4d viewToWorld(Point4d view) {
        this.updateLayout();
        return this.d_scene.get().viewToWorld(view);
    }

    public Point3d worldToLocal(Point3d world) {
        this.updateLayout();
        return this.d_scene.get().worldToLocal(world);
    }

    public Point3d worldToScreen(Point3d world) {
        this.updateLayout();
        return this.d_scene.get().worldToScreen(world);
    }

    public Point3d worldToScreen(Point4d world) {
        this.updateLayout();
        return this.d_scene.get().worldToScreen(world);
    }

    public Point3d screenToWorld(Point3d screen) {
        this.updateLayout();
        return this.d_scene.get().screenToWorld(screen);
    }

    public Point3d screenToWorld(Point2d screen, double z) {
        return this.screenToWorld(new Point3d(screen.x, screen.y, z));
    }

    public double screenToWorld(double lengthScreen, Point3d refWorld) {
        this.updateLayout();
        return this.d_scene.get().screenToWorld(lengthScreen, refWorld);
    }

    public Point3d viewToScreen(Point4d view) {
        this.updateLayout();
        return this.d_scene.get().viewToScreen(view);
    }

    public Point3d viewToScreen(Point3d view) {
        this.updateLayout();
        return this.d_scene.get().viewToScreen(view);
    }

    public Point3d screenToView(Point3d screen) {
        this.updateLayout();
        return this.d_scene.get().screenToView(screen);
    }

    public double screenToView(double lengthScreen) {
        this.updateLayout();
        return this.d_scene.get().screenToView(lengthScreen);
    }

    public Point3d screenToWorld(Point2d p) {
        double z = this.d_surface instanceof IConcreteRenderSurface ? (double)((IConcreteRenderSurface)this.d_surface).getZValue((int)p.x, (int)p.y) : 0.0;
        Point3d screen = new Point3d(p.x, p.y, z);
        return this.screenToWorld(screen);
    }

    public double screenToWorld(double lengthDisplay) {
        return this.screenToWorld(lengthDisplay, 0.0);
    }

    public double screenToWorld(double lengthDisplay, double z) {
        Point3d refWorld = this.screenToWorld(new Point3d(lengthDisplay, 0.0, z));
        Point3d originWorld = this.screenToWorld(new Point3d(0.0, 0.0, z));
        return refWorld.distance(originWorld);
    }

    public Point3d screenToCamera(Point3d screen) {
        this.updateLayout();
        return this.d_scene.get().screenToCamera(screen);
    }

    public Point2d windowScreenToViewScreen(Point windowScreen) {
        return this.windowScreenToViewScreen(new Point2d((double)windowScreen.x, (double)windowScreen.y));
    }

    public Point2d windowScreenToViewScreen(Point2d windowScreen) {
        double x = windowScreen.x;
        double y = (double)this.d_surface.getHeight() - windowScreen.y - 1.0;
        return new Point2d(x, y);
    }

    public Point2d viewScreenToWindowScreen(Point2d viewScreen) {
        double x = viewScreen.x;
        double y = (double)this.d_surface.getHeight() - viewScreen.y - 1.0;
        return new Point2d(x, y);
    }

    public Box3d toFrustum(Point2d center, double radius) {
        return (Box3d)this.toFrustum(center, radius, radius, false);
    }

    public ConvexHull toInfiniteFrustum(Point2d center, double radius) {
        return (ConvexHull)this.toFrustum(center, radius, radius, true);
    }

    public Box3d toFrustum(Point2d p1, Point2d p2) {
        Point2d center = new Point2d((p1.x + p2.x) * 0.5, (p1.y + p2.y) * 0.5);
        double halfWidth = Math.abs(center.x - p1.x);
        double halfHeight = Math.abs(center.y - p1.y);
        return (Box3d)this.toFrustum(center, halfWidth, halfHeight, false);
    }

    public ConvexHull toInfiniteFrustum(Point2d p1, Point2d p2) {
        Point2d center = new Point2d((p1.x + p2.x) * 0.5, (p1.y + p2.y) * 0.5);
        double halfWidth = Math.abs(center.x - p1.x);
        double halfHeight = Math.abs(center.y - p1.y);
        return (ConvexHull)this.toFrustum(center, halfWidth, halfHeight, true);
    }

    private ITest<AABox> toFrustum(Point2d center, double halfWidth, double halfHeight, boolean infinite) {
        Point3d p1 = new Point3d(center.x - halfWidth, center.y - halfHeight, 0.0);
        Point3d p2 = new Point3d(center.x + halfWidth, center.y - halfHeight, 0.0);
        Point3d p3 = new Point3d(center.x + halfWidth, center.y + halfHeight, 0.0);
        Point3d p4 = new Point3d(center.x - halfWidth, center.y + halfHeight, 0.0);
        Point3d p5 = new Point3d(p1.x, p1.y, 1.0);
        Point3d p6 = new Point3d(p2.x, p2.y, 1.0);
        Point3d p7 = new Point3d(p3.x, p3.y, 1.0);
        Point3d p8 = new Point3d(p4.x, p4.y, 1.0);
        p1 = this.screenToWorld(p1);
        p2 = this.screenToWorld(p2);
        p3 = this.screenToWorld(p3);
        p4 = this.screenToWorld(p4);
        p5 = this.screenToWorld(p5);
        p6 = this.screenToWorld(p6);
        p7 = this.screenToWorld(p7);
        p8 = this.screenToWorld(p8);
        if (!infinite) {
            return new Box3d(p1, p2, p3, p4, p5, p6, p7, p8);
        }
        return new ConvexHull(new Plane3d(true, p1, p5, p6, p2), new Plane3d(true, p2, p6, p7, p3), new Plane3d(true, p4, p3, p7, p8), new Plane3d(true, p4, p8, p5, p1));
    }

    public Box3d getFrustum() {
        int width = this.getSurface().getWidth();
        int height = this.getSurface().getHeight();
        return this.toFrustum(new Point2d(0.0, 0.0), new Point2d((double)width, (double)height));
    }

    public void updateLayout() {
        this.d_surface.updateLayout();
    }

    public Matrix4d getTransform(int from, int to) {
        this.updateLayout();
        return this.getCamera().getTransform(from, to);
    }
}

