/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Component;
import java.util.function.Function;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.RProp;
import thunderheadeng.util.RWProp;
import thunderheadeng.util.Win32Native;
import thunderheadeng.video.IVideoCompressor;

public class VideoCompressor
extends ANativeObject
implements IVideoCompressor {
    private static final Unit DATARATE_UNIT = SI.BIT.divide((Unit)SI.SECOND);
    private static final Unit QUALITY_UNIT = Unit.ONE;

    protected VideoCompressor(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return VideoCompressor.class;
    }

    private <T> T exec(Methods method, Function<NativeManager, T> get, Object ... args) {
        return Native.manager.exec(VideoCompressor.class, (INativeObject)this, (Enum)method, get, args);
    }

    private void exec(Methods method, Object ... args) {
        Native.manager.execMethod(VideoCompressor.class, (INativeObject)this, method, args);
    }

    @Override
    public boolean hasPropsDlg(Component parent) {
        long hwnd = Win32Native.findHwnd(parent);
        if (hwnd == 0L) {
            return false;
        }
        return this.exec(Methods.hasPropsDlg, ABufferedNativeStream::readBoolean, hwnd);
    }

    @Override
    public void showPropsDlg(Component parent) {
        long hwnd = Win32Native.findHwnd(parent);
        if (hwnd == 0L) {
            return;
        }
        this.exec(Methods.showPropsDlg, hwnd);
    }

    @Override
    public boolean hasAboutDlg(Component parent) {
        long hwnd = Win32Native.findHwnd(parent);
        if (hwnd == 0L) {
            return false;
        }
        return this.exec(Methods.hasAboutDlg, ABufferedNativeStream::readBoolean, hwnd);
    }

    @Override
    public void showAboutDlg(Component parent) {
        long hwnd = Win32Native.findHwnd(parent);
        if (hwnd == 0L) {
            return;
        }
        this.exec(Methods.showAboutDlg, hwnd);
    }

    @Override
    public <T> T get(RProp<T> prop) {
        if (prop == DATARATE) {
            Integer v = this.exec(Methods.get, ABufferedNativeStream::readInt, (Integer)prop.key);
            return (T)new UnitDouble(v.intValue(), DATARATE_UNIT);
        }
        if (prop == QUALITY) {
            Double v = this.exec(Methods.get, ABufferedNativeStream::readDouble, (Integer)prop.key);
            return (T)new UnitDouble(v, QUALITY_UNIT);
        }
        return (T)this.exec(Methods.get, (NativeManager m) -> m.read(rProp.type), (Integer)prop.key);
    }

    @Override
    public <T> void set(RWProp<T> prop, T value) {
        Object v = prop == DATARATE ? (Number)((int)((UnitDouble)value).get(DATARATE_UNIT)) : (Number)(prop == QUALITY ? Double.valueOf(((UnitDouble)value).get(QUALITY_UNIT)) : value);
        this.exec(Methods.set, (Integer)prop.key, v);
    }

    @Override
    public <T> T getDefault(RWProp<T> prop) {
        if (prop == DATARATE) {
            Integer v = this.exec(Methods.getDefault, ABufferedNativeStream::readInt, (Integer)prop.key);
            return (T)new UnitDouble(v.intValue(), DATARATE_UNIT);
        }
        if (prop == QUALITY) {
            Double v = this.exec(Methods.getDefault, ABufferedNativeStream::readDouble, (Integer)prop.key);
            return (T)new UnitDouble(v, QUALITY_UNIT);
        }
        return (T)this.exec(Methods.getDefault, (NativeManager m) -> m.read(rWProp.type), (Integer)prop.key);
    }

    @Override
    public <T> boolean isSupported(RWProp<T> prop) {
        return this.exec(Methods.isSupported, ABufferedNativeStream::readBoolean, (Integer)prop.key);
    }

    private static enum Methods {
        get,
        set,
        isSupported,
        getDefault,
        hasPropsDlg,
        showPropsDlg,
        hasAboutDlg,
        showAboutDlg;

    }
}

