/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.nativebuffered.TextRenderer;

public class StringRenderer
extends Object3D
implements IRenderable {
    private static final int method_setRenderer = 0;
    private static final int method_setString = 1;
    private static final int method_setLocation = 2;
    private static final int method_getBounds = 3;
    private static final int method_setColor = 4;
    private static final int method_setOffset = 5;
    private static final int method_setJustification = 6;
    private static final int method_setAnchor = 7;

    public StringRenderer() {
    }

    protected StringRenderer(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return StringRenderer.class;
    }

    public AABox getBounds(boolean include2dText) {
        return this.getBounds(new BoundsCalculator(), include2dText).getBounds();
    }

    public BoundsCalculator getBounds(BoundsCalculator bc, boolean include2dText) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 3, bc, include2dText);
        return bc;
    }

    public void setColor(Color c) {
        if (c == null) {
            Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 4, false);
        } else {
            Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 4, true, (byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue(), (byte)c.getAlpha());
        }
    }

    public void setRenderer(TextRenderer tr) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 0, tr);
    }

    public void setLocation(Point3d loc, Object3D parent) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 2, loc.x, loc.y, loc.z, parent);
    }

    public void setOffset(Offset offset) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 5, offset.ordinal());
    }

    public void setString(String str) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 1, str);
    }

    public void setJustification(Justification jst) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 6, jst.ordinal());
    }

    public void setAnchor(Point3d anchor) {
        this.setAnchor((float)anchor.x, (float)anchor.y, (float)anchor.z);
    }

    public void setAnchor(float x, float y, float z) {
        Native.manager.execMethod(StringRenderer.class, (INativeObject)this, 7, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
    }

    public static enum Justification {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum Offset {
        MIN,
        MAX,
        CENTER;

    }
}

