/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.lang.reflect.Array;
import java.util.Observable;
import java.util.Observer;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeManager;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.util.IPropertySet;

public final class SceneRenderOptions
extends ANativeObject
implements ISceneRenderOptions {
    private ObservableHelper d_observableHelper = new ObservableHelper();

    public SceneRenderOptions() {
    }

    protected SceneRenderOptions(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return SceneRenderOptions.class;
    }

    public void addObserver(Observer observer) {
        this.d_observableHelper.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.d_observableHelper.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.d_observableHelper.deleteObservers();
    }

    @Override
    public SceneRenderOptions clone() {
        SceneRenderOptions props = (SceneRenderOptions)super.clone();
        props.d_observableHelper = new ObservableHelper();
        for (IPropertySet.Prop prop : ALL_PROPS) {
            props.set(prop, this.get(prop));
        }
        return props;
    }

    protected void markDirty(IPropertySet.Prop<?> prop) {
        this.d_observableHelper.setChanged();
        this.d_observableHelper.notifyObservers(prop);
    }

    private static Integer key(IPropertySet.Prop<?> prop) {
        return (Integer)prop.key;
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        if (prop.defVal.getClass().isArray()) {
            int len = Array.getLength(prop.defVal);
            return (T)Native.manager.exec(SceneRenderOptions.class, (INativeObject)this, (Enum)Methods.getProp, m -> m.readArray(prop.defVal.getClass(), len), SceneRenderOptions.key(prop));
        }
        return (T)Native.manager.execGet(SceneRenderOptions.class, (INativeObject)this, Methods.getProp, prop.defVal.getClass(), SceneRenderOptions.key(prop));
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        assert (val != null);
        Native.manager.execMethod(SceneRenderOptions.class, (INativeObject)this, Methods.setProp, SceneRenderOptions.key(prop), val);
        this.markDirty(prop);
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        Native.manager.execMethod(SceneRenderOptions.class, (INativeObject)this, Methods.removeProp, SceneRenderOptions.key(prop));
        this.markDirty(prop);
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return Native.manager.exec(SceneRenderOptions.class, (INativeObject)this, (Enum)Methods.isDefined, ABufferedNativeStream::readBoolean, SceneRenderOptions.key(prop));
    }

    public void merge(SceneRenderOptions src) {
        this.merge((IPropertySet)src, ALL_PROPS.stream());
    }

    public void setDepthTestEnabled(boolean enabled) {
        this.set(DEPTHTEST_ENABLED, enabled);
    }

    public boolean isDepthTestEnabled() {
        return (Boolean)this.get(DEPTHTEST_ENABLED);
    }

    public void setPolygonOffset(float factor, float units) {
        this.set(SOLID_POLYGON_OFFSET, new float[]{factor, units});
    }

    public float[] getPolygonOffset() {
        return (float[])this.get(SOLID_POLYGON_OFFSET);
    }

    public ISceneRenderOptions.LightModel getLightModel() {
        return (ISceneRenderOptions.LightModel)((Object)this.get(LIGHTMODEL));
    }

    public void setLightModel(ISceneRenderOptions.LightModel lm) {
        this.set(LIGHTMODEL, lm);
    }

    public void setDrawOutlines(boolean drawOutlines) {
        this.set(DRAW_OUTLINES, drawOutlines);
    }

    public boolean drawOutlines() {
        return (Boolean)this.get(DRAW_OUTLINES);
    }

    public void setShowTextures(boolean drawTextures) {
        this.set(DRAW_TEXTURES, drawTextures);
    }

    public boolean showTextures() {
        return (Boolean)this.get(DRAW_TEXTURES);
    }

    public void setShowMaterials(boolean drawMaterials) {
        this.set(DRAW_MATERIALS, drawMaterials);
    }

    public boolean showMaterials() {
        return (Boolean)this.get(DRAW_MATERIALS);
    }

    public void setDrawWireframe(boolean drawWireframe) {
        this.set(DRAW_WIREFRAME, drawWireframe);
    }

    public boolean drawWireframe() {
        return (Boolean)this.get(DRAW_WIREFRAME);
    }

    public boolean drawSelectedFaceOutlines() {
        return (Boolean)this.get(DRAW_SELECTED_FACES_OUTLINE);
    }

    public void setDrawSelectedFaceOutlines(boolean enabled) {
        this.set(DRAW_SELECTED_FACES_OUTLINE, enabled);
    }

    public boolean getAutoClip() {
        return (Boolean)this.get(AUTO_CLIP);
    }

    public void setAutoClip(boolean autoClip) {
        this.set(AUTO_CLIP, autoClip);
    }

    static {
        NativeManager.registerWriter(ISceneRenderOptions.LightModel.class, (out, lm) -> out.writeInt(lm.ordinal()));
        NativeManager.registerReader(ISceneRenderOptions.LightModel.class, in -> ISceneRenderOptions.LightModel.values()[in.readInt()]);
    }

    private static class ObservableHelper
    extends Observable {
        private ObservableHelper() {
        }

        @Override
        public void setChanged() {
            super.setChanged();
        }
    }

    private static enum Methods {
        setProp,
        getProp,
        removeProp,
        isDefined;

    }
}

