/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.ARenderCounter;
import thunderheadeng.scene3d.nativebuffered.ARenderSurface;
import thunderheadeng.scene3d.nativebuffered.IConcreteRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.RenderWindow;
import thunderheadeng.scene3d.nativebuffered.SurfaceProps;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.util.IPropertySet;

public class RenderComponent
extends Canvas
implements IConcreteRenderSurface {
    private boolean d_nativeSurfaceCreated = false;
    private boolean d_canRender = false;
    private boolean d_resourcesValid = false;
    private final SurfaceProps d_props;
    private BiConsumer<RenderWindow, Viewport> d_renderer;
    private final RenderWindow d_helperSurface;
    private final Painter d_painter;
    private final List<Consumer<RenderComponent>> d_resourceInitListeners;
    private final ARenderCounter d_renderCounter = new ARenderCounter(){

        @Override
        protected void forceRender(Viewport vp) {
            RenderComponent.this.forceRender(vp);
        }

        @Override
        protected Viewport getFullVP() {
            return new Viewport(0, 0, RenderComponent.this.getWidth(), RenderComponent.this.getHeight());
        }
    };

    private native void lock(int var1);

    private native void unlock(int var1);

    private native boolean initResources(int var1, int var2, int var3, int var4, int var5, int[] var6, int var7, int[] var8, int var9, int var10);

    private native void freeResources(int var1);

    private void lock() {
        Native.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RenderComponent.this.lock(RenderComponent.this.getKey());
            }
        });
    }

    private void unlock() {
        Native.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RenderComponent.this.unlock(RenderComponent.this.getKey());
            }
        });
    }

    private void freeResources() {
        Native.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                RenderComponent.this.freeResources(RenderComponent.this.getKey());
            }
        });
    }

    private boolean initResources(final IRenderSurface sharingSurface) {
        return Native.invokeAndWait(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                int shareKey = sharingSurface == null ? 0 : sharingSurface.getKey();
                SurfaceProps p = RenderComponent.this.d_props;
                return RenderComponent.this.initResources(RenderComponent.this.getKey(), shareKey, p.compType.ordinal(), p.multisamples, p.nSurfs, p.nColorBits, p.nAccumBitPlanes, p.nAccumColorBits, p.nDepthBits, p.nStencilBits);
            }
        });
    }

    public RenderComponent() {
        this(new SurfaceProps());
    }

    public RenderComponent(SurfaceProps props) {
        this(props, null);
    }

    public RenderComponent(IRenderSurface sharingSurface) {
        this(new SurfaceProps(), sharingSurface);
    }

    public RenderComponent(SurfaceProps props, IRenderSurface sharingSurface) {
        this.d_helperSurface = new RenderWindow(sharingSurface);
        this.d_renderer = ARenderSurface::render;
        this.d_painter = new Painter();
        this.setMinimumSize(new Dimension(0, 0));
        this.d_resourceInitListeners = new ArrayList<Consumer<RenderComponent>>();
        this.d_props = props;
    }

    public void addResourceInitListener(Consumer<RenderComponent> listener) {
        if (this.d_resourcesValid) {
            listener.accept(this);
        } else {
            this.d_resourceInitListeners.add(listener);
        }
    }

    public void setRenderer(BiConsumer<RenderWindow, Viewport> renderer) {
        this.d_renderer = renderer;
    }

    public void setToDefaultRenderer() {
        this.d_renderer = ARenderSurface::render;
    }

    public RenderWindow getRenderSurface() {
        return this.d_helperSurface;
    }

    public boolean isInitialized() {
        return this.d_nativeSurfaceCreated;
    }

    public void setSharingSurface(IRenderSurface sharingSurface) {
        assert (!this.d_nativeSurfaceCreated);
        this.d_helperSurface.setSharingSurface(sharingSurface);
    }

    @Override
    public Cursor getCursor() {
        Cursor pcursor;
        Container parent = this.getParent();
        if (parent != null && (pcursor = parent.getCursor()).equals(Cursor.getPredefinedCursor(3))) {
            return pcursor;
        }
        return super.getCursor();
    }

    public boolean initResources() {
        if (!this.d_nativeSurfaceCreated) {
            RenderComponent shareComp;
            IRenderSurface sharingSurf = this.d_helperSurface.getSharingSurface();
            if (sharingSurf instanceof RenderComponent && !(shareComp = (RenderComponent)sharingSurf).isInitialized()) {
                shareComp.setSharingSurface(this);
                sharingSurf = null;
            }
            this.d_resourcesValid = this.initResources(sharingSurf);
            this.d_nativeSurfaceCreated = true;
            if (this.d_resourcesValid) {
                for (Consumer<RenderComponent> listener : this.d_resourceInitListeners) {
                    listener.accept(this);
                }
                this.d_resourceInitListeners.clear();
            }
        }
        return this.d_resourcesValid;
    }

    @Override
    public float getZValue(int sx, int sy) {
        return this.d_helperSurface.getZValue(sx, sy);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.d_helperSurface.setSize(width, height);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.d_helperSurface.setSize(width, height);
    }

    @Override
    public void setRootPanel(RenderPanel layout) {
        this.d_helperSurface.setRootPanel(layout);
    }

    @Override
    public RenderPanel getRootPanel() {
        return this.d_helperSurface.getRootPanel();
    }

    @Override
    public void updateLayout() {
        this.d_helperSurface.updateLayout();
    }

    @Override
    public <T> void setProp(IPropertySet.Prop<T> prop, T value) {
        this.d_helperSurface.setProp(prop, value);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.d_canRender = true;
        this.setVisible(false);
        this.setVisible(true);
    }

    @Override
    public void removeNotify() {
        this.d_canRender = false;
        Native.manager.flush();
        this.freeResources();
        this.d_nativeSurfaceCreated = false;
        this.d_resourcesValid = false;
        super.removeNotify();
    }

    public void redraw() {
        this.render();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.render(new Viewport(0, 0, this.getWidth(), this.getHeight()));
    }

    protected synchronized void forceRender(Viewport clippingVP) {
        this.d_painter.d_clippingVP = clippingVP;
        if (EventQueue.isDispatchThread()) {
            this.d_painter.run();
        } else {
            try {
                EventQueue.invokeLater(this.d_painter);
            }
            catch (Exception e) {
                System.err.println("Render thread interrupted.");
            }
        }
    }

    @Override
    public Integer getKey() {
        return this.d_helperSurface.getKey();
    }

    private final Viewport rectToVp(Rectangle r) {
        if (r == null) {
            return new Viewport(0, 0, this.getWidth(), this.getHeight());
        }
        int width = r.width;
        int height = r.height;
        int x = r.x;
        int y = this.getHeight() - (r.y + r.height) - 1;
        return new Viewport(x, y, width, height);
    }

    @Override
    public void pauseRender() {
        this.d_renderCounter.pauseRender();
    }

    @Override
    public void render() {
        this.d_renderCounter.render();
    }

    @Override
    public void render(Viewport clippingVP) {
        this.d_renderCounter.render(clippingVP);
    }

    @Override
    public void resumeRender() {
        this.d_renderCounter.resumeRender();
    }

    @Override
    public void resumeRender(boolean render) {
        this.d_renderCounter.resumeRender(render);
    }

    @Override
    public IRenderSurface.OpenGLInfo getOpenGLInfo() {
        return this.d_helperSurface.getOpenGLInfo();
    }

    @Override
    public IRenderSurface.Adapter getAdapter() {
        return this.d_helperSurface.getAdapter();
    }

    @Override
    public int testRenderCapabilities(int tests) {
        return this.d_helperSurface.testRenderCapabilities(tests);
    }

    @Override
    public boolean getMaterialShadersEnabled() {
        return this.d_helperSurface.getMaterialShadersEnabled();
    }

    @Override
    public void setMaterialShadersEnabled(boolean enabled, boolean clearCacheOnDisable) {
        this.d_helperSurface.setMaterialShadersEnabled(enabled, clearCacheOnDisable);
    }

    private class Painter
    implements Runnable {
        private volatile Viewport d_clippingVP;

        private Painter() {
        }

        @Override
        public void run() {
            if (!RenderComponent.this.d_canRender) {
                return;
            }
            RenderComponent.this.d_canRender = false;
            Native.manager.flush();
            RenderComponent.this.initResources();
            RenderComponent.this.d_helperSurface.getFPSTimer().start();
            RenderComponent.this.lock();
            RenderComponent.this.d_renderer.accept(RenderComponent.this.d_helperSurface, this.d_clippingVP);
            RenderComponent.this.unlock();
            RenderComponent.this.d_helperSurface.getFPSTimer().stop();
            RenderComponent.this.d_canRender = true;
        }
    }
}

