/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.io.IOException;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.function.Function;
import thunderheadeng.image.IImage;
import thunderheadeng.io.nativexfer.ANativelyMirrored;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.scene3d.GeomWriter;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.scene3d.nativebuffered.NativeGeomWriterOutput;
import thunderheadeng.scene3d.nativebuffered.NativeImage;
import thunderheadeng.scene3d.nativebuffered.NativeImageMgr;
import thunderheadeng.util.ListMap;

public class NativeMaterial
extends ANativelyMirrored {
    private IMatAttrs d_material;
    private Map<IImage, NativeImage> d_nimageMap;

    public NativeMaterial(IMatAttrs mat) {
        this.d_material = mat;
        this.d_nimageMap = new ListMap<IImage, NativeImage>();
        this.updateNativeImages();
        this.nativeConstructed(NativeMaterial.class);
    }

    protected NativeMaterial(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return NativeMaterial.class;
    }

    public IMatAttrs getObject() {
        return this.d_material;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof NativeMaterial && ((NativeMaterial)obj).d_material.equals(this.d_material);
    }

    @Override
    public int hashCode() {
        return 0x33F8FFA ^ this.d_material.hashCode();
    }

    @Override
    public void writeNativeData(INativeStream writer) {
        block2: {
            NativeGeomWriterOutput nwriter = new NativeGeomWriterOutput(writer){

                @Override
                public void writeObject(Object obj) throws IOException {
                    if (obj instanceof Texture) {
                        GeomWriter.write((ObjectOutput)this, (Texture)obj);
                        return;
                    }
                    if (obj instanceof IImage) {
                        obj = NativeMaterial.this.d_nimageMap.get(obj);
                    }
                    super.writeObject(obj);
                }
            };
            try {
                GeomWriter.write((ObjectOutput)nwriter, this.d_material);
            }
            catch (IOException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private void updateNativeImages() {
        this.d_nimageMap.clear();
        Function<IImage, NativeImage> nimgGetter = i -> NativeImageMgr.getImage(i);
        for (MatChannel chnl : MatChannel.values()) {
            Texture tex = this.d_material.getTexture(chnl);
            if (tex == null || tex.image == null) continue;
            this.d_nimageMap.computeIfAbsent(tex.image, nimgGetter);
        }
    }

    public void update() {
        this.updateNativeImages();
        this.markNativeDirty();
    }
}

