/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Keyable;

public interface IRenderSurface
extends Keyable {
    public static final int CAP_FAST_DEPTH_READS = 1;
    public static final int CAP_FAST_COLOR_READS = 2;
    public static final int CAP_FAST_VERTEX_BUFFERS = 4;
    public static final int CAP_FAST_SHADERS = 8;
    public static final int CAP_CONTEXT_SHARING = 16;
    public static final int ALL_CAPS = 31;
    public static final IPropertySet.Prop<YesNoAuto> PROP_COMPRESS_SIZE4 = new IPropertySet.Prop<YesNoAuto>(633075, YesNoAuto.AUTO);
    public static final IPropertySet.Prop<Double> PROP_MAX_TEXTURE_ANISOTROPY = new IPropertySet.Prop<Double>(717615, 16.0);

    public void setSize(int var1, int var2);

    public int getWidth();

    public int getHeight();

    public void setRootPanel(RenderPanel var1);

    public RenderPanel getRootPanel();

    public void updateLayout();

    public void repaint();

    public void pauseRender();

    public void render();

    public void render(Viewport var1);

    public void resumeRender();

    public void resumeRender(boolean var1);

    public <T> void setProp(IPropertySet.Prop<T> var1, T var2);

    public OpenGLInfo getOpenGLInfo();

    default public String getRenderID() {
        OpenGLInfo info = this.getOpenGLInfo();
        return info.vendor + " " + info.renderer;
    }

    public Adapter getAdapter();

    public int testRenderCapabilities(int var1);

    public void setMaterialShadersEnabled(boolean var1, boolean var2);

    public boolean getMaterialShadersEnabled();

    public static class OpenGLInfo {
        public final String vendor;
        public final String renderer;
        public final VersionInfo version;
        public final VersionInfo glslVersion;
        public final int build;

        public OpenGLInfo(String vendor, String renderer, VersionInfo version, VersionInfo glslVersion, int build) {
            this.vendor = vendor;
            this.renderer = renderer;
            this.version = version;
            this.glslVersion = glslVersion;
            this.build = build;
        }

        public OpenGLInfo() {
            this("", "", new VersionInfo(), new VersionInfo(), -1);
        }
    }

    public static class VersionInfo {
        public final String versionStr;
        public final Version version;
        public final String vendorVer;

        public VersionInfo(String versionStr, Version version, String vendorVer) {
            this.versionStr = versionStr;
            this.version = version;
            this.vendorVer = vendorVer;
        }

        public VersionInfo() {
            this("", new Version(), "");
        }
    }

    public static class Version {
        public final int major;
        public final int minor;
        public final int release;

        public Version(int major, int minor, int release) {
            this.major = major;
            this.minor = minor;
            this.release = release;
        }

        public Version() {
            this(1, 1, 0);
        }
    }

    public static enum Adapter {
        AMD,
        NVIDIA,
        INTEL,
        UNKNOWN;

    }

    public static enum YesNoAuto {
        NO,
        YES,
        AUTO;

    }
}

