/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import java.awt.geom.Point2D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.Object3D;

public class GenericActor
extends Object3D
implements IRenderable {
    private static final int resetData = 0;
    private static final int finalizeData = 1;
    private static final int setSelectionKey = 2;
    private static final int setVisible = 3;
    private static final int setTexture = 4;
    private static final int setLineStipplePattern = 5;
    private static final int setPolygonStipplePattern = 6;
    private static final int addPoint = 7;
    private static final int addLine = 8;
    private static final int addQuad = 9;
    private static final int addTriangle = 10;
    private static final int addTexturedQuad = 11;
    private static final int setTransform = 12;
    private static final int setCullFrontFace = 13;
    private static final int setWireframe = 14;
    private static final int setLineWidth = 15;
    private static final int setOpacity = 16;
    private static final int setColor = 17;
    private static final int setPointSize = 18;
    private static final Color DEF_LINE_COLOR = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    private static final Color DEF_POLY_COLOR = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    private static final Color DEF_POINT_COLOR = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    private Color d_lineColor = DEF_LINE_COLOR;
    private Color d_polyColor = DEF_POLY_COLOR;
    private Color d_pointColor = DEF_POINT_COLOR;
    private boolean d_visible = true;
    private boolean d_empty = true;
    private int d_selectionKey;

    public GenericActor() {
    }

    protected GenericActor(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return GenericActor.class;
    }

    public void resetData() {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 0, new Object[0]);
        this.d_empty = true;
    }

    public void finalizeData() {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 1, new Object[0]);
    }

    public boolean isEmpty() {
        return this.d_empty;
    }

    public Object getData() {
        return null;
    }

    public void setSelectionKey(int key) {
        this.d_selectionKey = key;
    }

    public int getSelectionKey() {
        return this.d_selectionKey;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.d_visible) {
            return;
        }
        this.d_visible = visible;
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 3, visible);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    public void setLineStipplePattern(int factor, short pattern) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 5, factor, pattern);
    }

    public void setPolygonStipplePattern(byte[] pattern) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 6, pattern.length, pattern);
    }

    private final float[] getComps(Color c) {
        float[] color = new float[4];
        c.getComponents(color);
        return color;
    }

    public void setFaceColor(Color c) {
        this.d_polyColor = c;
    }

    public void setEdgeColor(Color c) {
        this.d_lineColor = c;
    }

    public void setVertexColor(Color c) {
        this.d_pointColor = c;
    }

    public void setColor(Color c) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 17, new Object[]{this.getComps(c)});
    }

    public void addPoint(Point3d p) {
        this.addPoint(p, this.d_pointColor);
    }

    public void addPoint(Point3d p, Color c) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 7, this.getComps(c), p.x, p.y, p.z);
        this.d_empty = false;
    }

    public void addLine(Point3d p1, Point3d p2) {
        this.addLine(p1, p2, this.d_lineColor);
    }

    public void addLine(Point3d p1, Point3d p2, Color c) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 8, this.getComps(c), p1.x, p1.y, p1.z, p2.x, p2.y, p2.z);
        this.d_empty = false;
    }

    public void addTriangle(Point3d p1, Point3d p2, Point3d p3) {
        this.addTriangle(p1, p2, p3, this.d_polyColor);
    }

    public void addTriangle(Point3d p1, Point3d p2, Point3d p3, Color c) {
        Vector3d normal = GenericActor.calcNormal(p1, p2, p3);
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 10, this.getComps(c), normal.x, normal.y, normal.z, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, p3.x, p3.y, p3.z);
        this.d_empty = false;
    }

    public void addQuad(Point3d p1, Point3d p2, Point3d p3, Point3d p4) {
        this.addQuad(p1, p2, p3, p4, this.d_polyColor);
    }

    public void addQuad(Point3d p1, Point3d p2, Point3d p3, Point3d p4, Color c) {
        Vector3d normal = GenericActor.calcNormal(p1, p2, p3);
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 9, this.getComps(c), normal.x, normal.y, normal.z, p1.x, p1.y, p1.z, p2.x, p2.y, p2.z, p3.x, p3.y, p3.z, p4.x, p4.y, p4.z);
        this.d_empty = false;
    }

    public void addTexturedQuad(Point3d p1, Point3d p2, Point3d p3, Point3d p4, Point2D t1, Point2D t2, Point2D t3, Point2D t4) {
    }

    private static Vector3d calcNormal(Point3d p1, Point3d p2, Point3d p3) {
        Vector3d v1 = new Vector3d();
        v1.sub((Tuple3d)p2, (Tuple3d)p1);
        Vector3d v2 = new Vector3d();
        v2.sub((Tuple3d)p3, (Tuple3d)p1);
        Vector3d normal = new Vector3d();
        normal.cross(v1, v2);
        normal.normalize();
        return normal;
    }

    public void addTriangleStrip(Point3d[] points, Color c) {
    }

    public void setTransform(Matrix4d xform) {
    }

    public void setCullFrontFace(boolean cull) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 13, cull);
    }

    public void setWireframe(boolean wireframe) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 14, wireframe);
    }

    public void setPointSize(double pointSize) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 18, pointSize);
    }

    public void setLineWidth(double lineWidth) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 15, lineWidth);
    }

    public void setOpacity(double opacity) {
        Native.manager.execMethod(GenericActor.class, (INativeObject)this, 16, opacity);
    }
}

