/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.util.Map;
import java.util.WeakHashMap;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.NativeMaterial;

public class DefNativeDisplayProps
implements INativeDisplayProps {
    private final Map<IMaterial, NativeMaterial> d_materials = new WeakHashMap<IMaterial, NativeMaterial>();
    private final Map<IMatAttrs, NativeMaterial> d_attrMats = new WeakHashMap<IMatAttrs, NativeMaterial>();
    private double d_curveError;
    private double d_faceError;

    public DefNativeDisplayProps() {
        this(0.01, 0.1);
    }

    public DefNativeDisplayProps(double curveError, double faceError) {
        this.d_curveError = curveError;
        this.d_faceError = faceError;
    }

    @Override
    public double getCurveError() {
        return this.d_curveError;
    }

    public void setCurveError(double error) {
        this.d_curveError = error;
    }

    @Override
    public double getFaceError() {
        return this.d_faceError;
    }

    public void setFaceError(double error) {
        this.d_faceError = error;
    }

    public NativeMaterial registerMat(IMaterial mat) {
        return this.updateMat(mat, false);
    }

    public NativeMaterial updateMat(IMaterial mat) {
        return this.updateMat(mat, true);
    }

    private NativeMaterial updateMat(IMaterial mat, boolean forceUpdate) {
        NativeMaterial nmat = this.d_materials.get(mat);
        if (nmat == null || forceUpdate) {
            IMatAttrs attrs = mat.getAttributes();
            nmat = this.d_attrMats.get(attrs);
            if (nmat == null) {
                nmat = new NativeMaterial(attrs);
                this.d_attrMats.put(attrs, nmat);
            }
            this.d_materials.put(mat, nmat);
        }
        return nmat;
    }

    public void removeMat(IMaterial mat) {
        this.d_materials.remove(mat);
    }

    public void clearMaterials() {
        this.d_materials.clear();
    }

    @Override
    public NativeMaterial getNativeMat(IMaterial mat) {
        return this.d_materials.get(mat);
    }
}

