/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Color;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.nativebuffered.ARenderComponent;
import thunderheadeng.scene3d.nativebuffered.IRenderComponent;

public class ClearableBackground
extends ARenderComponent
implements IRenderComponent {
    public ClearableBackground(boolean clearColor, boolean clearDepth) {
        this.setColorClearEnabled(clearColor);
        this.setClearColor(Color.WHITE);
        this.setDepthClearEnabled(clearDepth);
        this.setClearDepth(1.0);
    }

    protected ClearableBackground(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return ClearableBackground.class;
    }

    public void setColorClearEnabled(boolean enabled) {
        this.exec(Methods.setColorClearEnabled, enabled);
    }

    public void setDepthClearEnabled(boolean enabled) {
        this.exec(Methods.setDepthClearEnabled, enabled);
    }

    public void setStencilClearEnabled(boolean enabled) {
        this.exec(Methods.setStencilClearEnabled, enabled);
    }

    public void setColor(Color c) {
        this.setClearColor(c);
    }

    public void setClearColor(Color color) {
        float[] c = new float[4];
        color.getComponents(c);
        this.exec(Methods.setClearColor, Float.valueOf(c[0]), Float.valueOf(c[1]), Float.valueOf(c[2]), Float.valueOf(c[3]));
    }

    public void setClearDepth(double depth) {
        this.exec(Methods.setClearDepth, depth);
    }

    public void setClearStencil(int stencil) {
        this.exec(Methods.setClearStencil, stencil);
    }

    private void exec(Methods method, Object ... args) {
        Native.manager.execMethod(ClearableBackground.class, (INativeObject)this, method, args);
    }

    private static enum Methods {
        setColorClearEnabled,
        setDepthClearEnabled,
        setStencilClearEnabled,
        setClearColor,
        setClearDepth,
        setClearStencil;

    }
}

