/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.nativebuffered;

import java.awt.Dimension;
import java.util.function.Supplier;
import thunderheadeng.io.nativexfer.ANativeObject;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.FPSTimer;
import thunderheadeng.scene3d.nativebuffered.ARenderCounter;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.Viewport;
import thunderheadeng.scene3d.nativebuffered.nb3dUtil;
import thunderheadeng.util.IPropertySet;

public abstract class ARenderSurface
extends ANativeObject
implements IRenderSurface {
    private FPSTimer d_fpsTimer = new FPSTimer();
    private Thread d_animatingThread = null;
    private ARenderCounter d_renderCounter = new ARenderCounter(){

        @Override
        protected void forceRender(Viewport vp) {
            ARenderSurface.this.forceRender(vp);
        }

        @Override
        protected Viewport getFullVP() {
            return new Viewport(0, 0, ARenderSurface.this.getWidth(), ARenderSurface.this.getHeight());
        }
    };

    protected abstract void forceRender(Viewport var1);

    public ARenderSurface() {
        this.setRootPanel(new RenderPanel());
    }

    protected ARenderSurface(Integer key, long cptr) {
        super(key, cptr);
    }

    @Override
    public Class resolveNativeClass() {
        return ARenderSurface.class;
    }

    private void exec(Methods method, Object ... args) {
        Native.manager.execMethod(ARenderSurface.class, (INativeObject)this, method, args);
    }

    @Override
    public void setRootPanel(RenderPanel rootPanel) {
        this.exec(Methods.setRootPanel, rootPanel);
    }

    @Override
    public RenderPanel getRootPanel() {
        return Native.manager.execGet(ARenderSurface.class, (INativeObject)this, Methods.getRootPanel, RenderPanel.class, new Object[0]);
    }

    @Override
    public void updateLayout() {
        this.exec(Methods.updateLayout, new Object[0]);
    }

    @Override
    public void setSize(int width, int height) {
        this.exec(Methods.setSize, width, height);
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    public Dimension getSize() {
        return Native.manager.exec(ARenderSurface.class, (INativeObject)this, (Enum)Methods.getSize, nb3dUtil::readDimension, new Object[0]);
    }

    public FPSTimer getFPSTimer() {
        return this.d_fpsTimer;
    }

    @Override
    public void pauseRender() {
        this.d_renderCounter.pauseRender();
    }

    @Override
    public void render() {
        this.d_renderCounter.render();
    }

    @Override
    public void render(Viewport clippingVP) {
        this.d_renderCounter.render(clippingVP);
    }

    @Override
    public void resumeRender() {
        this.d_renderCounter.resumeRender();
    }

    @Override
    public void resumeRender(boolean render) {
        this.d_renderCounter.resumeRender(render);
    }

    @Override
    public <T> void setProp(IPropertySet.Prop<T> prop, T value) {
        if (!(prop.key instanceof Integer)) {
            return;
        }
        Object v = value;
        if (prop == PROP_COMPRESS_SIZE4) {
            v = ((IRenderSurface.YesNoAuto)((Object)value)).ordinal();
        }
        this.exec(Methods.setProp, prop.key, v);
    }

    @Override
    public IRenderSurface.OpenGLInfo getOpenGLInfo() {
        Native.manager.lockWriteBuffer();
        Native.manager.execMethod(ARenderSurface.class, (INativeObject)this, Methods.getOpenGLInfo, new Object[0]);
        Native.manager.flush();
        String vendor = Native.manager.readString();
        String renderer = Native.manager.readString();
        Supplier<IRenderSurface.VersionInfo> readVersion = () -> {
            String vstr = Native.manager.readString();
            int major = Native.manager.readInt();
            int minor = Native.manager.readInt();
            int release = Native.manager.readInt();
            String vendorVer = Native.manager.readString();
            return new IRenderSurface.VersionInfo(vstr, new IRenderSurface.Version(major, minor, release), vendorVer);
        };
        IRenderSurface.VersionInfo version = readVersion.get();
        IRenderSurface.VersionInfo glslVersion = readVersion.get();
        int build = Native.manager.readInt();
        IRenderSurface.OpenGLInfo di = new IRenderSurface.OpenGLInfo(vendor, renderer, version, glslVersion, build);
        Native.manager.unlockWriteBuffer();
        return di;
    }

    @Override
    public IRenderSurface.Adapter getAdapter() {
        int ival = Native.manager.execGet(ARenderSurface.class, (INativeObject)this, Methods.getAdapter, Integer.class, new Object[0]);
        return IRenderSurface.Adapter.values()[ival];
    }

    @Override
    public int testRenderCapabilities(int tests) {
        return Native.manager.execGet(ARenderSurface.class, (INativeObject)this, Methods.testCapabilities, Integer.class, tests);
    }

    @Override
    public void setMaterialShadersEnabled(boolean enabled, boolean clearCacheOnDisable) {
        Native.manager.execMethod(ARenderSurface.class, (INativeObject)this, Methods.setMaterialShadersEnabled, enabled, clearCacheOnDisable);
    }

    @Override
    public boolean getMaterialShadersEnabled() {
        return Native.manager.execGet(ARenderSurface.class, (INativeObject)this, Methods.getMaterialShadersEnabled, Boolean.class, new Object[0]);
    }

    private static enum Methods {
        updateLayout,
        setRootPanel,
        getRootPanel,
        setSize,
        getSize,
        setProp,
        getOpenGLInfo,
        getAdapter,
        testCapabilities,
        setMaterialShadersEnabled,
        getMaterialShadersEnabled;

    }
}

