/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.manip;

import java.awt.geom.NoninvertibleTransformException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.manip.IManipListener;
import thunderheadeng.scene3d.manip.ManipEvent;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public class ManipMgr {
    private final IDisplayMgr<Object> d_dispMgr;
    private IMutableGeomSrc d_source;
    private IMutableGeomSrc d_sourceClone;
    private Collection<IHandle> d_handles;
    private IHandle d_currHandle;
    private ManipInfo d_manipInfo;
    private boolean d_modified;
    private final List<WeakReference<IManipListener>> d_listeners;

    public ManipMgr(IDisplayMgr<Object> dispMgr) {
        this.d_dispMgr = dispMgr;
        this.d_source = null;
        this.d_handles = Collections.EMPTY_LIST;
        this.d_currHandle = null;
        this.d_manipInfo = null;
        this.d_modified = false;
        this.d_listeners = new ArrayList<WeakReference<IManipListener>>();
    }

    public void addListener(IManipListener listener) {
        Iterator<WeakReference<IManipListener>> it = this.d_listeners.iterator();
        while (it.hasNext()) {
            IManipListener existing = (IManipListener)it.next().get();
            if (existing == null) {
                it.remove();
                continue;
            }
            if (existing != listener) continue;
            return;
        }
        this.d_listeners.add(new WeakReference<IManipListener>(listener));
    }

    public void removeListener(IManipListener listener) {
        Iterator<WeakReference<IManipListener>> it = this.d_listeners.iterator();
        while (it.hasNext()) {
            IManipListener existing = (IManipListener)it.next().get();
            if (existing == null) {
                it.remove();
                continue;
            }
            if (existing != listener) continue;
            it.remove();
            break;
        }
    }

    public IManipListener[] getListeners() {
        ArrayList<IManipListener> listeners = new ArrayList<IManipListener>(this.d_listeners.size());
        for (WeakReference<IManipListener> ref : this.d_listeners) {
            IManipListener list = (IManipListener)ref.get();
            if (list == null) continue;
            listeners.add(list);
        }
        return listeners.toArray(new IManipListener[listeners.size()]);
    }

    protected void fireEvent(ManipEvent evt) {
        for (IManipListener listener : this.getListeners()) {
            listener.manipChanged(evt);
        }
    }

    public IDisplayMgr<Object> getDisplayMgr() {
        return this.d_dispMgr;
    }

    public IMutableGeomSrc getCurrentManipObj() {
        return this.d_source;
    }

    public IHandle getSelectedHandle() {
        return this.d_currHandle;
    }

    public void setSource(IMutableGeomSrc src) {
        if (this.d_source == src) {
            return;
        }
        IMutableGeomSrc oldSrc = this.d_source;
        this.d_source = src;
        this.updateSource(src);
        this.fireEvent(ManipEvent.sourceChanged(this, oldSrc));
    }

    /*
     * WARNING - void declaration
     */
    public void updateSource(IMutableGeomSrc source) {
        boolean maintainCurrHandle = this.isManipulating();
        this.d_handles = Collections.EMPTY_LIST;
        IHandle newHandle = null;
        if (source != null) {
            IHandle searchHandle = this.d_currHandle;
            Collection<? extends IHandle> handles = ManipMgr.generateHandles(source);
            this.d_handles = new ArrayList<IHandle>(handles.size());
            for (IHandle iHandle : handles) {
                void var7_7;
                if (iHandle.equals(searchHandle)) {
                    if (maintainCurrHandle) {
                        IHandle iHandle2 = searchHandle;
                    }
                    newHandle = var7_7;
                    searchHandle = null;
                }
                this.d_handles.add((IHandle)var7_7);
            }
        }
        this.fireEvent(ManipEvent.handlesModified(this));
        if (this.d_currHandle != newHandle) {
            if (maintainCurrHandle && newHandle == null) {
                System.err.println("Lost current manip handle");
                this.end(false);
            }
            this.setSelectedHandle(newHandle);
        }
    }

    public Collection<IHandle> getCurrentHandles() {
        return this.d_handles;
    }

    public boolean canManipulate() {
        return this.d_source != null;
    }

    public boolean isManipulating() {
        return this.d_manipInfo != null;
    }

    public boolean isManipulating(Object o) {
        return this.isManipulating() && (this.d_source == o || this.d_sourceClone == o);
    }

    public Point3d getManipBegin() {
        return this.d_manipInfo != null ? this.d_manipInfo.origLoc : null;
    }

    public Point3d getManipLast() {
        return this.d_manipInfo != null ? this.d_manipInfo.lastLoc : null;
    }

    public ISnapConstraint getManipConstraint() {
        return this.d_manipInfo != null ? this.d_manipInfo.constraint : null;
    }

    public boolean isModified() {
        return this.d_modified;
    }

    public void setSelectedHandle(IHandle handle) {
        assert (handle == null || this.d_source != null && this.d_handles.contains(handle));
        if (this.d_currHandle == handle) {
            return;
        }
        IHandle old = this.d_currHandle;
        this.d_currHandle = handle;
        this.fireEvent(ManipEvent.activeHandleChanged(this, old));
    }

    public void begin(Point3d handlePick) {
        assert (this.d_source != null && this.d_currHandle != null);
        this.d_sourceClone = (IMutableGeomSrc)this.d_source.clone();
        this.d_dispMgr.addDisplays(Arrays.asList(this.d_sourceClone));
        this.d_dispMgr.removeFromScene(Arrays.asList(this.d_source));
        Point3d handleLoc = handlePick;
        IGeomNode oldGeom = this.d_sourceClone.getGeom();
        ISnapConstraint constraint = this.d_currHandle.getConstraint(handleLoc);
        this.d_currHandle.begin(handleLoc, constraint);
        this.d_manipInfo = new ManipInfo(oldGeom, handleLoc, constraint);
        this.fireEvent(ManipEvent.manipStarted(this));
    }

    public void modify(Point3d newLoc) throws ManipException {
        assert (this.isManipulating());
        this.d_manipInfo.lastLoc = newLoc;
        Object modified = this.d_currHandle.modify(newLoc);
        if (modified instanceof IGeomNode) {
            this.d_modified = true;
            IGeomNode newNode = (IGeomNode)modified;
            this.d_sourceClone.setGeom(newNode);
            this.d_dispMgr.updateDisplays(Arrays.asList(this.d_sourceClone));
            this.updateSource(this.d_sourceClone);
        }
    }

    public void end(boolean commit) {
        assert (this.isManipulating());
        commit &= this.d_modified;
        this.d_modified = false;
        this.d_manipInfo = null;
        IGeomNode newGeom = null;
        Object finalModified = this.d_currHandle.end();
        if (finalModified instanceof IGeomNode) {
            newGeom = (IGeomNode)finalModified;
        } else {
            commit = false;
        }
        this.d_dispMgr.removeDisplays(Arrays.asList(this.d_sourceClone));
        this.d_sourceClone = null;
        this.d_dispMgr.addToScene(Arrays.asList(this.d_source));
        this.fireEvent(ManipEvent.manipEnded(this, commit, newGeom));
        if (!commit) {
            this.updateSource(this.d_source);
        }
    }

    public static boolean canManipulate(IMutableGeomSrc obj) {
        return !ManipMgr.generateHandles(obj).isEmpty();
    }

    private static Collection<? extends IHandle> generateHandles(IMutableGeomSrc obj) {
        return ManipMgr.generateManipHandles(obj.getGeom());
    }

    private static Collection<? extends IHandle> generateManipHandles(IGeomNode node) {
        IGeom geom = node.getLocalGeom();
        if (!(geom instanceof IManipulatable)) {
            return Collections.EMPTY_LIST;
        }
        Collection<? extends IHandle> geomHandles = ((IManipulatable)((Object)geom)).generateManipHandles();
        ArrayList<Handle> handles = new ArrayList<Handle>(geomHandles.size());
        for (IHandle iHandle : geomHandles) {
            handles.add(new Handle(node, iHandle));
        }
        return handles;
    }

    protected static class ManipInfo {
        public final IGeomNode oldGeom;
        public final Point3d origLoc;
        public final ISnapConstraint constraint;
        public Point3d lastLoc;

        public ManipInfo(IGeomNode oldGeom, Point3d origLoc, ISnapConstraint constraint) {
            this.oldGeom = oldGeom;
            this.origLoc = origLoc;
            this.constraint = constraint;
            this.lastLoc = origLoc;
        }
    }

    private static class Handle
    implements IHandle {
        private IGeomNode d_node;
        private final IHandle d_handle;
        private Matrix4d t_xform;
        private Matrix4d t_invXform;

        public Handle(IGeomNode node, IHandle handle) {
            this.d_node = node;
            this.d_handle = handle;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Handle && ((Handle)obj).d_handle.equals(this.d_handle);
        }

        @Override
        public IGeomNode getGeom() {
            return this.d_handle.getGeom().quickTransform(this.d_node.getLocalTransform().getInfo());
        }

        @Override
        public Pair<SnapMode, IIsectFilter> getPickFilter() {
            return this.d_handle.getPickFilter();
        }

        @Override
        public ISnapConstraint getConstraint(Point3d handleLoc) {
            try {
                this.t_invXform = this.d_node.getLocalTransform().invert().toMatrix(false);
            }
            catch (NoninvertibleTransformException e) {
                e.printStackTrace();
                this.t_invXform = GeomConstants.IDENTITY4d;
            }
            this.t_xform = this.d_node.getLocalTransform().toMatrix(false);
            handleLoc = Util3D.xform(this.t_invXform, handleLoc);
            ISnapConstraint constraint = this.d_handle.getConstraint(handleLoc);
            return constraint == null ? constraint : constraint.transform(this.t_xform);
        }

        @Override
        public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            assert (this.t_invXform != null && this.t_xform != null);
            handleLoc = Util3D.xform(this.t_invXform, handleLoc);
            constraint = constraint == null ? constraint : constraint.transform(this.t_invXform);
            this.d_handle.begin(handleLoc, constraint);
        }

        @Override
        public Object modify(Point3d newLoc) throws ManipException {
            newLoc = Util3D.xform(this.t_invXform, newLoc);
            Object mod = this.d_handle.modify(newLoc);
            this.d_node = this.modify(mod);
            return this.d_node;
        }

        @Override
        public Object end() {
            this.d_node = this.modify(this.d_handle.end());
            this.t_invXform = null;
            this.t_xform = null;
            return this.d_node;
        }

        private IGeomNode modify(Object mod) {
            if (mod instanceof IGeom) {
                return this.d_node.applyLocalGeom((IGeom)mod);
            }
            return this.d_node;
        }
    }
}

