/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.scene3d.nativebuffered.SurfaceProps;
import thunderheadeng.util.BitOptions;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class RenderPrefs {
    public static final TypedProp<String> VIDEO_ADAPTER = new TypedProp<String>((Object)"System.videoAdapter", "");
    public static final TypedProp<Integer> ADAPTER_VERSION = new TypedProp<Integer>((Object)"System.videoAdapter.version", -1);
    public static final TypedProp<Boolean> INTEL_WARNING_SHOWN = new TypedProp<Boolean>((Object)"System.intelWarningShown", false);
    public static final TypedProp<Boolean> PREF_USEVERTEXBUFFERS = new TypedProp<Boolean>((Object)"UseVertexBuffers", true);
    public static final TypedProp<Boolean> PREF_SCENESHADERS = new TypedProp<Boolean>((Object)"UseSceneShaders", true);
    public static final TypedProp<Double> PREF_ANISOTROPIC_FILTERING = new TypedProp<Double>((Object)"AnisotropicFiltering", 16.0);
    public static final TypedProp<Integer> PREF_MULTISAMPLES = new TypedProp<Integer>((Object)"Multisamples", 4);

    public static SurfaceProps getDefaultSurfaceProps(TeciProps prefs) {
        SurfaceProps sprops = new SurfaceProps();
        sprops.multisamples = prefs.getInt(PREF_MULTISAMPLES);
        return sprops;
    }

    public static void applyPrefs(TeciProps prefs, Stream<IRenderSurface> renderComponents, Stream<ModelScene> scenes, Stream<ISceneRenderOptions> renderOptions) {
        boolean useVertexBuffers = prefs.getBoolean(PREF_USEVERTEXBUFFERS);
        scenes.forEach(scene -> scene.forceImmediate(!useVertexBuffers));
        boolean sceneShaders = prefs.getBoolean(PREF_SCENESHADERS);
        double aniso = prefs.getDouble(PREF_ANISOTROPIC_FILTERING);
        renderComponents.forEach(rc -> {
            rc.setProp(IRenderSurface.PROP_MAX_TEXTURE_ANISOTROPY, aniso);
            rc.setMaterialShadersEnabled(sceneShaders, true);
        });
    }

    public static boolean detectVideoAdapter(TeciProps prefs, boolean safeMode, IRenderSurface renderSurf, boolean forceRedetect, BiConsumer<TeciProps, BitOptions> getAdditionalDefaultPrefs) {
        if (safeMode) {
            return false;
        }
        String prevVideoAdapter = prefs.getString(VIDEO_ADAPTER);
        String renderId = renderSurf.getRenderID();
        System.out.println("Detected Video Adapter = " + renderId);
        int version = renderSurf.getOpenGLInfo().build;
        if (version != -1) {
            System.out.println("Video Adapter Version = " + version);
        }
        if (forceRedetect || !renderId.equals(prevVideoAdapter) || renderSurf.getAdapter() == IRenderSurface.Adapter.INTEL && version != prefs.getInt(ADAPTER_VERSION)) {
            RenderPrefs.loadDefaultPrefs(prefs, renderSurf, true, getAdditionalDefaultPrefs);
            return true;
        }
        return false;
    }

    private static void loadDefaultPrefs(TeciProps prefs, IRenderSurface d_renderComp, boolean resetWarnings, BiConsumer<TeciProps, BitOptions> getAdditionalDefaultPrefs) {
        TeciProps defPrefs = RenderPrefs.getDefaultPrefs(d_renderComp, getAdditionalDefaultPrefs);
        if (resetWarnings && !prefs.partialEquals(defPrefs)) {
            prefs.set(INTEL_WARNING_SHOWN, Boolean.valueOf(false));
        }
        prefs.putAll((Map<?, ?>)defPrefs);
        int version = d_renderComp.getOpenGLInfo().build;
        prefs.set(ADAPTER_VERSION, Integer.valueOf(version));
        prefs.set(VIDEO_ADAPTER, d_renderComp.getRenderID());
    }

    public static TeciProps getDefaultPrefs(IRenderSurface d_renderComp, BiConsumer<TeciProps, BitOptions> getAdditionalDefaultPrefs) {
        String renderId = d_renderComp.getRenderID();
        System.out.print("Testing " + renderId + "...");
        int caps = d_renderComp.testRenderCapabilities(31);
        TeciProps props = new TeciProps();
        getAdditionalDefaultPrefs.accept(props, new BitOptions(caps));
        props.set(PREF_USEVERTEXBUFFERS, Boolean.valueOf(RenderPrefs.testCap(caps, 4)));
        props.set(PREF_SCENESHADERS, Boolean.valueOf(RenderPrefs.testCap(caps, 8)));
        props.set(PREF_ANISOTROPIC_FILTERING, RenderPrefs.PREF_ANISOTROPIC_FILTERING.defVal);
        props.set(PREF_MULTISAMPLES, RenderPrefs.PREF_MULTISAMPLES.defVal);
        System.out.printf("done (caps = %d)%n", caps);
        return props;
    }

    private static boolean testCap(int caps, int flag) {
        return (caps & flag) == flag;
    }

    public static TeciProps getCompatibilityPrefs() {
        TeciProps props = new TeciProps();
        props.set(PREF_SCENESHADERS, Boolean.valueOf(false));
        props.set(PREF_ANISOTROPIC_FILTERING, Double.valueOf(1.0));
        props.set(PREF_MULTISAMPLES, Integer.valueOf(0));
        return props;
    }

    public static void loadSafeModeProps(TeciProps props) {
        TeciProps cprops = RenderPrefs.getCompatibilityPrefs();
        cprops.set(PREF_USEVERTEXBUFFERS, Boolean.valueOf(false));
        for (Map.Entry<Object, Object> prefs : cprops.entrySet()) {
            System.out.printf("Setting preference \"%s\"=%s%n", prefs.getKey(), prefs.getValue());
        }
        props.putAll((Map<?, ?>)cprops);
    }

    public static void showIntelWarning(String appName, RenderComponent renderComp, TeciProps prefs) {
        renderComp.addResourceInitListener(rc -> {
            if (renderComp.getAdapter() == IRenderSurface.Adapter.INTEL && !prefs.getBoolean(INTEL_WARNING_SHOWN)) {
                EventQueue.invokeLater(() -> RenderPrefs.showIntelWarning(renderComp, appName, () -> renderComp.getOpenGLInfo(), remember -> prefs.set(INTEL_WARNING_SHOWN, remember)));
            }
        });
    }

    public static void showIntelWarning(Component parent, String appName, Supplier<IRenderSurface.OpenGLInfo> getRenderInfo, Consumer<Boolean> setRememberPref) {
        IRenderSurface.OpenGLInfo caps = getRenderInfo.get();
        String msg = String.format(Intl.intl("%1$s has detected Intel graphics. In some cases, out-of-date drivers for this adapter\n(%2$s) have been associated with rendering errors, including\nblank and corrupted visualization.\n\nIf you experience display issues, go to the <b>File</b> menu and select <b>Preferences</b>.\nOn the <b>Rendering</b> tab, choose <b>Max Compatibility</b>."), appName, caps.renderer);
        msg = "<html>" + msg.replace("\n", "<br>");
        guiDialog dlg = new guiDialog(SwingUtilities.getWindowAncestor(parent), Intl.intl("Intel Graphics Detected"), 1);
        guiCheckBox remember = new guiCheckBox(Intl.intl("Do not show this warning again."));
        remember.setSelected(true);
        GridBagHelper gb = new GridBagHelper(dlg.getDialogPane());
        gb.addRow(msg, 1, 1.0);
        gb.addRow(remember);
        gb.finalizeRows();
        dlg.doModal();
        setRememberPref.accept(remember.isSelected());
    }

    public static guiPanel getRenderPrefsBtns(Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp, Consumer<IPropertySet> loadPrefs) {
        JButton prefBtn = new JButton(Intl.intl("Max Quality"));
        prefBtn.setToolTipText(Intl.intl("Loads rendering preferences for maximum quality rendering."));
        JButton compBtn = new JButton(Intl.intl("Max Compatibility"));
        compBtn.setToolTipText(Intl.intl("Loads rendering preferences for maximum compatibility with older graphics cards and drivers."));
        Function<Supplier, ActionListener> toActionListener = getPrefs -> arg_0 -> RenderPrefs.lambda$null$318((Supplier)getPrefs, loadPrefs, arg_0);
        prefBtn.addActionListener(toActionListener.apply(getRenderPref));
        compBtn.addActionListener(toActionListener.apply(getRenderComp));
        guiPanel pnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(pnl);
        gb.addRow(prefBtn, compBtn);
        return pnl;
    }

    private static /* synthetic */ void lambda$null$318(Supplier supplier, Consumer consumer, ActionEvent e) {
        IPropertySet props = (IPropertySet)supplier.get();
        consumer.accept(props);
    }

    public static class PrefsUI {
        private final String d_appName;
        private final guiCheckBox d_useVertexBuffers;
        private final guiComboBox<Boolean> d_sceneGeomRender;
        private final ValueField<Double> d_anisotropicFiltering;
        private final ValueField<Integer> d_multisamples;
        private boolean d_needsRestart = false;

        public PrefsUI(String appName) {
            this.d_appName = appName;
            this.d_useVertexBuffers = new guiCheckBox(Intl.intl("Hardware accelerated vertex buffers"));
            this.d_useVertexBuffers.setToolTipText(Intl.intl("Allows geometry data to be stored on the GPU. Enabling can greatly improve performance in the 3D and 2D Views"));
            this.d_sceneGeomRender = guiUtil.newCombo(Boolean.valueOf(true), Intl.intl("Use Hardware Shaders"), false, Intl.intl("Use Compatibility Renderer"));
            this.d_anisotropicFiltering = ValueFields.doubleFld(DoubleVR.above(1.0, true));
            this.d_multisamples = ValueFields.intFld(IntVR.above(0, true));
            this.d_multisamples.addValueListener(ValueField.VAL_CHANGE, e -> {
                this.d_needsRestart = true;
            });
        }

        public void addTo(GridBagHelper gb) {
            guiLabel sceneGeomLbl = new guiLabel(Intl.intl("Scene Geometry:"));
            sceneGeomLbl.setToolTipText("<html>" + Intl.intl("Determines how scene geometry is rendered.<br><b>Use Hardware Shaders</b>: Improves shading quality and may improve rendering performance with some GPUs.<br><b>Use Compatibility Renderer</b>: For use on older GPUs."));
            guiLabel anisoLbl = new guiLabel(Intl.intl("Anisotropic Filtering:"));
            anisoLbl.setToolTipText(Intl.intl("Controls the quality of textures when viewed at a large angle to the camera."));
            guiLabel msLbl = new guiLabel(Intl.intl("Multisamples (requires restart):"));
            msLbl.setToolTipText(Intl.intl("Controls the anti-aliasing quality. Set to 0 to disable for improved performance."));
            Consumer<Component> matchWidth = c -> c.setPreferredSize(new Dimension(this.d_sceneGeomRender.getPreferredSize().width, c.getPreferredSize().height));
            matchWidth.accept(this.d_multisamples);
            matchWidth.accept(this.d_anisotropicFiltering);
            gb.addRow(this.d_useVertexBuffers, 0);
            gb.addRow(sceneGeomLbl, this.d_sceneGeomRender);
            gb.addRow(msLbl, this.d_multisamples);
            gb.addRow(anisoLbl, this.d_anisotropicFiltering);
        }

        public void loadData(IPropertySet props, boolean onlyIfDefined, boolean clearRestart) {
            guiUtil.loadPref(props, onlyIfDefined, this.d_useVertexBuffers, PREF_USEVERTEXBUFFERS);
            guiUtil.loadPref(props, onlyIfDefined, this.d_sceneGeomRender, PREF_SCENESHADERS);
            guiUtil.loadPref(props, onlyIfDefined, this.d_anisotropicFiltering, PREF_ANISOTROPIC_FILTERING);
            guiUtil.loadPref(props, onlyIfDefined, this.d_multisamples, PREF_MULTISAMPLES);
            if (clearRestart) {
                this.d_needsRestart = false;
            }
        }

        public void saveData(IPropertySet props) {
            props.set(PREF_USEVERTEXBUFFERS, this.d_useVertexBuffers.isSelected());
            props.set(PREF_SCENESHADERS, this.d_sceneGeomRender.getSelectedItem());
            props.set(PREF_ANISOTROPIC_FILTERING, this.d_anisotropicFiltering.getValue());
            props.set(PREF_MULTISAMPLES, this.d_multisamples.getValue());
            this.d_needsRestart = false;
        }

        public boolean validateData(boolean showWarn, boolean allowMod) {
            if (this.d_needsRestart && showWarn) {
                Window parent = SwingUtilities.getWindowAncestor(this.d_anisotropicFiltering);
                JOptionPane.showMessageDialog(parent, String.format(Intl.intl("%s must be restarted for the changes to take place."), this.d_appName), Intl.intl("Restart Required"), 1);
            }
            return true;
        }
    }
}

