/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.gui;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.function.Supplier;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;

public class GPUInfoPnl
extends guiPanel {
    public GPUInfoPnl(Supplier<IRenderSurface.OpenGLInfo> getInfo, boolean copyInline) {
        Color transparent = new Color(0, 0, 0, 0);
        this.setBackground(transparent);
        IRenderSurface.OpenGLInfo info = getInfo.get();
        JButton copyBtn = new JButton(Intl.intl("Copy"), guiUtil.loadTeciIcon("Copy16.gif"));
        copyBtn.setMaximumSize(copyBtn.getSize());
        copyBtn.setToolTipText(Intl.intl("Copies the GPU information."));
        guiPanel leftPnl = new guiPanel();
        leftPnl.setBackground(transparent);
        GridBagHelper gb = new GridBagHelper(leftPnl);
        gb.addRow(Intl.intl("Vendor:"), info.vendor);
        gb.addRow(Intl.intl("Renderer:"), info.renderer);
        gb.addRow(Intl.intl("OpenGL Version:"), info.version.versionStr);
        gb.addRow(Intl.intl("GLSL Version:"), info.glslVersion.versionStr);
        if (!copyInline) {
            gb.addRow(copyBtn, 0);
        }
        gb.finalizeRows();
        if (copyInline) {
            gb = new GridBagHelper(this, false, 18, 0);
            gb.add(new Object[]{leftPnl, copyBtn, GridBagHelper.Anchor.RIGHT});
            gb.finalizeRows();
        } else {
            this.add(leftPnl);
        }
        copyBtn.addActionListener(e -> {
            try {
                String text = String.format("Vendor: %s\nRenderer: %s\nOpenGL Version: %s\nGLSL Version: %s", openGLInfo.vendor, openGLInfo.renderer, openGLInfo.version.versionStr, openGLInfo.glslVersion.versionStr);
                Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection data = new StringSelection(text);
                cb.setContents(data, data);
            }
            catch (IllegalStateException exc) {
                guiUtil.showError(SwingUtilities.getWindowAncestor(copyBtn), Intl.intl("Cannot Copy"), Intl.intl("Cannot copy"), (Throwable)exc);
                return;
            }
        });
    }
}

