/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.util.Iterator;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;

public class PropsSubList
implements IPropsSrc {
    static final long serialVersionUID = 1L;
    private final IPropsSrc d_baseProps;
    private final int d_offset;
    private final int d_length;

    public PropsSubList(IPropsSrc baseProps, int offset, int length) {
        this.d_baseProps = baseProps;
        this.d_offset = offset;
        this.d_length = length;
    }

    @Override
    public Iterator<IPrimProps> iterator() {
        return new It(this);
    }

    @Override
    public IPrimProps get(int ix) {
        return this.d_baseProps.get(ix + this.d_offset);
    }

    @Override
    public int getUniformCount(int startix, int maxCount) {
        return this.d_baseProps.getUniformCount(startix + this.d_offset, maxCount);
    }

    @Override
    public IPropsSrc subset(int startix, int count) {
        return this.d_baseProps.subset(startix + this.d_offset, count);
    }

    @Override
    public IPrimProps[] flatten(int count) {
        IPrimProps[] result = new IPrimProps[count];
        int end = this.d_offset + count;
        for (int m = this.d_offset; m < end; ++m) {
            result[m] = this.d_baseProps.get(m);
        }
        return result;
    }

    private static class It
    implements Iterator<IPrimProps> {
        public final PropsSubList d_list;
        private final int d_end;
        private int d_ix;

        public It(PropsSubList list) {
            this.d_list = list;
            this.d_ix = list.d_offset;
            this.d_end = list.d_offset + list.d_length;
        }

        @Override
        public boolean hasNext() {
            return this.d_ix < this.d_end;
        }

        @Override
        public IPrimProps next() {
            return this.d_list.d_baseProps.get(this.d_ix++);
        }
    }
}

