/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.AInfiniteElems;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;

public class PlanarCoordMapper
extends AInfiniteElems<Point2d>
implements Serializable {
    static final long serialVersionUID = 1L;
    private final Function<IMaterial, Point2d> d_matSize;
    private final Point3d d_texOrigin;

    public PlanarCoordMapper(Function<IMaterial, Point2d> matSize, Point3d texOrigin) {
        this.d_matSize = matSize;
        this.d_texOrigin = texOrigin;
    }

    @Override
    protected Point2d getDefVal() {
        return new Point2d();
    }

    @Override
    public void generate(Class<Point2d> type, List<? extends IPrimitive> prims, IElemSource<Elements.Orient> orients, IPropsSrc props, Consumer<Point2d> consumer) {
        int numPrims = prims.size();
        int ucount = props.getUniformCount(0, numPrims);
        if (ucount == numPrims) {
            Point2d size = this.d_matSize.apply(props.get(0).getMaterial());
            double iwidth = 1.0 / size.x;
            double iheight = 1.0 / size.y;
            for (int m = 0; m < prims.size(); ++m) {
                IPrimitive prim = prims.get(m);
                if (!(prim instanceof IPolygon)) continue;
                this.generate((IPolygon)prim, orients.getPrimElement(m), iwidth, iheight, consumer);
            }
        } else {
            Iterator<IPrimProps> propit = props.iterator();
            for (int m = 0; m < prims.size(); ++m) {
                IPrimitive prim = prims.get(m);
                if (!(prim instanceof IPolygon)) continue;
                this.generate((IPolygon)prim, orients.getPrimElement(m), propit.next(), consumer);
            }
        }
    }

    private void generate(IPolygon face, Elements.Orient orient, IPrimProps props, Consumer<Point2d> result) {
        Point2d size = this.d_matSize.apply(props.getMaterial());
        double iwidth = 1.0 / size.x;
        double iheight = 1.0 / size.y;
        this.generate(face, orient, iwidth, iheight, result);
    }

    private void generate(IPolygon face, Elements.Orient orient, double iwidth, double iheight, Consumer<Point2d> result) {
        Vector3d[] localVecs = PlanarCoordMapper.generateLocalVecs(face.getNormal(orient == Elements.Orient.CCW));
        int numLoops = face.getNumLoops();
        for (int m = 0; m < numLoops; ++m) {
            int numVerts = face.getNumPoints(m);
            for (int n = 0; n < numVerts; ++n) {
                Point3d p = face.getPoint(m, n);
                result.accept(PlanarCoordMapper.generateTexUV(this.d_texOrigin, iwidth, iheight, localVecs[0], localVecs[1], p));
            }
        }
    }

    @Override
    public ElementMesh<Point2d> generate(Class<Point2d> type, IPrimitive prim, Elements.Orient primOrient, Mesh tmesh, IPrimProps props) {
        if (tmesh.primtype != 2 && tmesh.primtype != 3) {
            return null;
        }
        Point3d[] tempPoints = new Point3d[3];
        List<Point3d> pList = Arrays.asList(tempPoints);
        boolean ccw = primOrient == Elements.Orient.CCW;
        Vector3d avgNormal = new Vector3d(0.0, 0.0, 0.0);
        int m = 0;
        while (m < tmesh.indices.length) {
            tempPoints[0] = tmesh.vertices[tmesh.indices[m++]];
            tempPoints[1] = tmesh.vertices[tmesh.indices[m++]];
            tempPoints[2] = tmesh.vertices[tmesh.indices[m++]];
            Vector3d tnorm = Util3D.simplePolygonNormal(pList, ccw);
            if (tnorm == null) continue;
            avgNormal.add((Tuple3d)tnorm);
        }
        double len = avgNormal.length();
        if (len > 0.0) {
            int numPolys = tmesh.getNumPrims(1);
            avgNormal.scale((double)(1 / numPolys));
            avgNormal.normalize();
        } else {
            avgNormal = GeomConstants.VEC3D_ZPOS;
        }
        Vector3d[] localVecs = PlanarCoordMapper.generateLocalVecs(avgNormal);
        Point2d size = this.d_matSize.apply(props.getMaterial());
        double iwidth = 1.0 / size.x;
        double iheight = 1.0 / size.y;
        Point2d[] uv = new Point2d[tmesh.vertices.length];
        for (int m2 = 0; m2 < tmesh.vertices.length; ++m2) {
            Point3d p = tmesh.vertices[m2];
            uv[m2] = PlanarCoordMapper.generateTexUV(this.d_texOrigin, iwidth, iheight, localVecs[0], localVecs[1], p);
        }
        return new ElementMesh<Point2d>(ElementMesh.Mapping.PER_PRIM_VERTEX, uv, tmesh.indices, tmesh.getNumVertsPerPrim());
    }

    private static Point2d generateTexUV(Point3d origin, double iwidth, double iheight, Vector3d tangent, Vector3d bitangent, Point3d p) {
        double dx = p.x - origin.x;
        double dy = p.y - origin.y;
        double dz = p.z - origin.z;
        double lx = tangent.x * dx + tangent.y * dy + tangent.z * dz;
        double ly = bitangent.x * dx + bitangent.y * dy + bitangent.z * dz;
        return new Point2d(lx * iwidth, ly * iheight);
    }

    private static Vector3d[] generateLocalVecs(Vector3d normal) {
        Vector3d tangent;
        if (normal.x == 0.0 && normal.y == 0.0) {
            tangent = new Vector3d(1.0, 0.0, 0.0);
        } else {
            tangent = new Vector3d(-normal.y, normal.x, 0.0);
            tangent.normalize();
        }
        Vector3d bitangent = Util3D.cross(normal, tangent);
        bitangent.normalize();
        return new Vector3d[]{tangent, bitangent};
    }
}

