/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.util.theUtil;

public interface IPrimProps
extends Serializable {
    public static final int DEF_STIPPLE = Edge.makeStipple(1, (short)-1);
    public static final IPrimProps DEF = new GenericProps(Color.BLACK, null, 1.0, DEF_STIPPLE, 1.0, 0);
    public static final int OPT_SELECTED = 1;
    public static final int OPT_CULLFACE = 2;
    public static final int FACE_OPTIONS = 3;
    public static final int EDGE_OPTIONS = 1;
    public static final int VERT_OPTIONS = 1;

    public int getOptions();

    public boolean testOptions(int var1);

    public IPrimProps setOptions(int var1);

    public Color getColor();

    public IPrimProps setColor(Color var1);

    public IMaterial getMaterial();

    public IPrimProps setMaterial(IMaterial var1);

    public double getEdgeWidth();

    public IPrimProps setEdgeWidth(double var1);

    public int getEdgeStipple();

    public IPrimProps setEdgeStipple(int var1);

    public double getPointSize();

    public IPrimProps setPointSize(double var1);

    public int hashCode();

    public boolean equals(Object var1);

    public static class Vertex
    extends AProps {
        static final long serialVersionUID = 1L;
        public final double pointSize;

        public Vertex(Color color, double pointSize) {
            this(color, pointSize, 0);
        }

        public Vertex(Color color, double pointSize, int options) {
            super(color, options);
            this.pointSize = pointSize;
        }

        @Override
        public double getPointSize() {
            return this.pointSize;
        }

        @Override
        public Vertex setPointSize(double pointSize) {
            return new Vertex(this.color, pointSize, this.options);
        }

        @Override
        public Vertex setColor(Color c) {
            return new Vertex(c, this.pointSize, this.options);
        }

        @Override
        public Vertex setOptions(int options) {
            return new Vertex(this.color, this.pointSize, options);
        }
    }

    public static class Edge
    extends AProps {
        static final long serialVersionUID = 1L;
        public final double edgeWidth;
        public final int stipple;

        public Edge(Color color, double edgeWidth, int stipple, int options) {
            super(color, options);
            assert (stipple != 0);
            this.stipple = stipple;
            this.edgeWidth = edgeWidth;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.stipple == 0) {
                try {
                    theUtil.assignFinalField(this, Edge.class, "stipple", DEF_STIPPLE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public int getEdgeStipple() {
            return this.stipple;
        }

        @Override
        public double getEdgeWidth() {
            return this.edgeWidth;
        }

        @Override
        public Edge setEdgeWidth(double edgeWidth) {
            return new Edge(this.color, edgeWidth, this.stipple, this.options);
        }

        @Override
        public IPrimProps setEdgeStipple(int edgeStipple) {
            return new Edge(this.color, this.edgeWidth, edgeStipple, this.options);
        }

        @Override
        public Edge setColor(Color c) {
            return new Edge(c, this.edgeWidth, this.stipple, this.options);
        }

        @Override
        public Edge setOptions(int options) {
            return new Edge(this.color, this.edgeWidth, this.stipple, options);
        }

        public static int makeStipple(int factor, short pattern) {
            return factor << 16 | pattern & 0xFFFF;
        }
    }

    public static class Face
    extends AProps {
        static final long serialVersionUID = 1L;
        public final IMaterial material;

        public Face(Color color, IMaterial material, int options) {
            super(color, options);
            this.material = material;
        }

        @Override
        public IMaterial getMaterial() {
            return this.material;
        }

        @Override
        public Face setMaterial(IMaterial matl) {
            return new Face(this.color, matl, this.options);
        }

        @Override
        public Face setColor(Color c) {
            return new Face(c, this.material, this.options);
        }

        @Override
        public Face setOptions(int options) {
            return new Face(this.color, this.material, options);
        }
    }

    public static class GenericProps
    extends AProps {
        static final long serialVersionUID = 1L;
        public final IMaterial material;
        public final double edgeWidth;
        public final double pointSize;
        public final int edgeStipple;

        public GenericProps(Color color, IMaterial material, double edgeWidth, int edgeStipple, double pointSize, int options) {
            super(color, options);
            assert (edgeStipple != 0);
            this.material = material;
            this.edgeWidth = edgeWidth;
            this.edgeStipple = edgeStipple;
            this.pointSize = pointSize;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.edgeStipple == 0) {
                try {
                    theUtil.assignFinalField(this, GenericProps.class, "edgeStipple", DEF_STIPPLE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public IMaterial getMaterial() {
            return this.material;
        }

        @Override
        public double getEdgeWidth() {
            return this.edgeWidth;
        }

        @Override
        public int getEdgeStipple() {
            return this.edgeStipple;
        }

        @Override
        public double getPointSize() {
            return this.pointSize;
        }

        @Override
        public GenericProps setColor(Color c) {
            return new GenericProps(c, this.material, this.edgeWidth, this.edgeStipple, this.pointSize, this.options);
        }

        @Override
        public GenericProps setOptions(int options) {
            return new GenericProps(this.color, this.material, this.edgeWidth, this.edgeStipple, this.pointSize, options);
        }

        public IPrimProps optimize(int primTypes) {
            return GenericProps.optimize(this, primTypes);
        }

        public static IPrimProps optimize(IPrimProps props, int primTypes) {
            switch (primTypes) {
                case 1: {
                    return props instanceof Face ? props : new Face(props.getColor(), props.getMaterial(), props.getOptions() & 3);
                }
                case 2: {
                    return props instanceof Edge ? props : new Edge(props.getColor(), props.getEdgeWidth(), props.getEdgeStipple(), props.getOptions() & 1);
                }
                case 4: {
                    return props instanceof Vertex ? props : new Vertex(props.getColor(), props.getPointSize(), props.getOptions() & 1);
                }
            }
            return props;
        }
    }

    public static abstract class AProps
    implements IPrimProps {
        static final long serialVersionUID = 1L;
        public final Color color;
        public final byte options;

        public AProps(Color color, int options) {
            this.color = color;
            this.options = (byte)options;
        }

        @Override
        public int hashCode() {
            return 5387087 + theUtil.hashCode(this.getOptions()) + theUtil.hashCode(this.getEdgeWidth()) + theUtil.hashCode(this.getPointSize()) + theUtil.hashCode(this.getColor()) + theUtil.hashCode(this.getMaterial()) + theUtil.hashCode(this.getEdgeStipple());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IPrimProps)) {
                return false;
            }
            IPrimProps props = (IPrimProps)obj;
            return this.getOptions() == props.getOptions() && this.getEdgeWidth() == props.getEdgeWidth() && this.getEdgeStipple() == props.getEdgeStipple() && this.getPointSize() == props.getPointSize() && theUtil.equal(this.getColor(), props.getColor()) && theUtil.equal(this.getMaterial(), props.getMaterial());
        }

        @Override
        public int getOptions() {
            return this.options;
        }

        @Override
        public boolean testOptions(int options) {
            return (this.options & options) == options;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public IMaterial getMaterial() {
            return null;
        }

        @Override
        public double getEdgeWidth() {
            return 1.0;
        }

        @Override
        public int getEdgeStipple() {
            return DEF_STIPPLE;
        }

        @Override
        public double getPointSize() {
            return 1.0;
        }

        @Override
        public IPrimProps setMaterial(IMaterial matl) {
            return new GenericProps(this.color, matl, this.getEdgeWidth(), this.getEdgeStipple(), this.getPointSize(), this.options);
        }

        @Override
        public IPrimProps setEdgeWidth(double edgeWidth) {
            return new GenericProps(this.color, this.getMaterial(), edgeWidth, this.getEdgeStipple(), this.getPointSize(), this.options);
        }

        @Override
        public IPrimProps setEdgeStipple(int edgeStipple) {
            return new GenericProps(this.color, this.getMaterial(), this.getEdgeWidth(), edgeStipple, this.getPointSize(), this.options);
        }

        @Override
        public IPrimProps setPointSize(double pointSize) {
            return new GenericProps(this.color, this.getMaterial(), this.getEdgeWidth(), this.getEdgeStipple(), pointSize, this.options);
        }
    }
}

