/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import thunderheadeng.TeciIO;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.MatUtil;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TypedProp;

public interface IMatAttrs
extends IPropertySet {
    public static final int OPT_ONESIDED = 2;
    public static final TypedProp<Integer> PROP_XML_VERSION = new TypedProp<Integer>((Object)"mat.version", XmlVersion.V000.ordinal());
    public static final MatProp<Texture> BUMP = MatUtil.newTexProp(0, "bump.tex");
    public static final MatProp<Double> BUMP_SCALE = MatUtil.newProp((Object)1, "bump.scale", 1.0);
    public static final MatProp<Color> AMBIENT_COLOR = MatUtil.newColorProp(2, "ambient.color", new Color(0.2f, 0.2f, 0.2f));
    public static final MatProp<Texture> AMBIENT_TEXTURE = MatUtil.newTexProp(3, "ambient.tex");
    public static final MatProp<Double> AMBIENT_FADE = MatUtil.newProp((Object)4, "ambient.fade", 1.0);
    public static final MatProp<Color> DIFFUSE_COLOR = MatUtil.newColorProp(5, "diffuse.color", Color.WHITE);
    public static final MatProp<Texture> DIFFUSE_TEXTURE = MatUtil.newTexProp(6, "diffuse.tex");
    public static final MatProp<Double> DIFFUSE_FADE = MatUtil.newProp((Object)7, "diffuse.fade", 1.0);
    public static final MatProp<Color> EMISSIVE_COLOR = MatUtil.newColorProp(8, "emissive.color", Color.BLACK);
    public static final MatProp<Texture> EMISSIVE_TEXTURE = MatUtil.newTexProp(9, "emissive.tex");
    public static final MatProp<Double> EMISSIVE_FADE = MatUtil.newProp((Object)10, "emissive.fade", 1.0);
    public static final MatProp<Texture> NORMAL = MatUtil.newTexProp(11, "normal.tex");
    public static final MatProp<Color> OPACITY_COLOR = MatUtil.newColorProp(12, "opacity.color", Color.WHITE);
    public static final MatProp<Texture> OPACITY_TEXTURE = MatUtil.newTexProp(13, "opacity.tex");
    public static final MatProp<Double> OPACITY_FADE = MatUtil.newProp((Object)14, "opacity.fade", 1.0);
    public static final MatProp<Color> REFLECTION_COLOR = MatUtil.newColorProp(15, "reflection.color", Color.BLACK);
    public static final MatProp<Texture> REFLECTION_TEXTURE = MatUtil.newTexProp(16, "reflection.tex");
    public static final MatProp<Double> REFLECTION_FADE = MatUtil.newProp((Object)17, "reflection.fade", 1.0);
    public static final MatProp<Color> SPECULAR_COLOR = MatUtil.newColorProp(18, "specular.color", Color.BLACK);
    public static final MatProp<Texture> SPECULAR_TEXTURE = MatUtil.newTexProp(19, "specular.tex");
    public static final MatProp<Double> SPECULAR_FADE = MatUtil.newProp((Object)20, "specular.fade", 1.0);
    public static final MatProp<Double> SHININESS = MatUtil.newProp((Object)21, "shininess", 0.0);
    public static final MatProp<Integer> OPTIONS = MatUtil.newProp((Object)22, "options", 0);
    public static final List<MatProp<?>> ALL = Arrays.asList(BUMP, BUMP_SCALE, AMBIENT_COLOR, AMBIENT_TEXTURE, AMBIENT_FADE, DIFFUSE_COLOR, DIFFUSE_TEXTURE, DIFFUSE_FADE, EMISSIVE_COLOR, EMISSIVE_TEXTURE, EMISSIVE_FADE, NORMAL, OPACITY_COLOR, OPACITY_TEXTURE, OPACITY_FADE, REFLECTION_COLOR, REFLECTION_TEXTURE, REFLECTION_FADE, SPECULAR_COLOR, SPECULAR_TEXTURE, SPECULAR_FADE, SHININESS, OPTIONS);

    default public Texture getTexture(MatChannel chnl) {
        switch (chnl) {
            case AMBIENT: {
                return this.get(AMBIENT_TEXTURE);
            }
            case BUMP: {
                return this.get(BUMP);
            }
            case DIFFUSE: {
                return this.get(DIFFUSE_TEXTURE);
            }
            case EMISSIVE: {
                return this.get(EMISSIVE_TEXTURE);
            }
            case NORMAL: {
                return this.get(NORMAL);
            }
            case OPACITY: {
                return this.get(OPACITY_TEXTURE);
            }
            case REFLECTION: {
                return this.get(REFLECTION_TEXTURE);
            }
            case SPECULAR: {
                return this.get(SPECULAR_TEXTURE);
            }
        }
        return null;
    }

    default public Color getColor(MatChannel chnl) {
        switch (chnl) {
            case AMBIENT: {
                return this.get(AMBIENT_COLOR);
            }
            case BUMP: {
                return null;
            }
            case DIFFUSE: {
                return this.get(DIFFUSE_COLOR);
            }
            case EMISSIVE: {
                return this.get(EMISSIVE_COLOR);
            }
            case NORMAL: {
                return null;
            }
            case OPACITY: {
                return this.get(OPACITY_COLOR);
            }
            case REFLECTION: {
                return this.get(REFLECTION_COLOR);
            }
            case SPECULAR: {
                return this.get(SPECULAR_COLOR);
            }
        }
        return null;
    }

    default public double getFade(MatChannel chnl) {
        switch (chnl) {
            case AMBIENT: {
                return this.get(AMBIENT_FADE);
            }
            case BUMP: {
                return 1.0;
            }
            case DIFFUSE: {
                return this.get(DIFFUSE_FADE);
            }
            case EMISSIVE: {
                return this.get(EMISSIVE_FADE);
            }
            case NORMAL: {
                return 1.0;
            }
            case OPACITY: {
                return this.get(OPACITY_FADE);
            }
            case REFLECTION: {
                return this.get(REFLECTION_FADE);
            }
            case SPECULAR: {
                return this.get(SPECULAR_FADE);
            }
        }
        return 1.0;
    }

    default public int getOptions() {
        return this.get(OPTIONS);
    }

    public static IMatAttrs load(TeciProps props, Function<String, IImage> imgLoader) {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (MatProp<?> prop : ALL) {
            vals.add(prop);
            vals.add(prop.load(props, imgLoader));
        }
        XmlVersion ver = XmlVersion.parse(props.getInt(PROP_XML_VERSION));
        MatAttrs result = new MatAttrs(vals);
        if (ver.ordinal() < XmlVersion.V001.ordinal()) {
            result = TeciIO.resolvePre16MatAttrs(result);
        }
        return result;
    }

    default public void save(TeciProps props, Function<IImage, String> imgSaver) {
        props.setIfNotDefault(PROP_XML_VERSION, XmlVersion.curr().ordinal());
        for (MatProp<?> prop : ALL) {
            prop.save(props, imgSaver, this.get(prop));
        }
    }

    default public Set<String> getUVSets() {
        return MatUtil.getUVSets(this);
    }

    default public int getAlphaFromDiffuseAndOpacity() {
        Color d = this.getColor(MatChannel.DIFFUSE);
        Color o = this.getColor(MatChannel.OPACITY);
        return d.getAlpha() * o.getRed() / 255;
    }

    default public Color getDiffuseColorWithOpacity() {
        Color c = this.getColor(MatChannel.DIFFUSE);
        if (c == null) {
            return c;
        }
        Color opac = this.getColor(MatChannel.OPACITY);
        int a = c.getAlpha() * opac.getRed() / 255;
        if (a == c.getAlpha()) {
            return c;
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

    public static class MatProp<T>
    extends IPropertySet.Prop<T> {
        public final TriConsumer<TeciProps, Function<IImage, String>, T> xmlSaver;
        public final BiFunction<TeciProps, Function<String, IImage>, T> xmlLoader;

        public MatProp(Object key, T defVal, TriConsumer<TeciProps, Function<IImage, String>, T> xmlSaver, BiFunction<TeciProps, Function<String, IImage>, T> xmlLoader) {
            super(key, defVal);
            this.xmlSaver = xmlSaver;
            this.xmlLoader = xmlLoader;
        }

        public T load(TeciProps props, Function<String, IImage> imgLoader) {
            return this.xmlLoader.apply(props, imgLoader);
        }

        public void save(TeciProps props, Function<IImage, String> imgSaver, T val) {
            this.xmlSaver.accept(props, imgSaver, val);
        }
    }

    public static enum XmlVersion {
        V000,
        V001;


        public static XmlVersion curr() {
            return XmlVersion.values()[XmlVersion.values().length - 1];
        }

        public static XmlVersion parse(int val) {
            if (val >= XmlVersion.values().length) {
                return V000;
            }
            return XmlVersion.values()[val];
        }
    }
}

