/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.geom;

import java.util.ArrayList;
import java.util.Collection;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.ElementsBuilder;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.IPropertySet;

public class DisplayGeomBuilder {
    public static final Rep EMPTY_REP = new Rep(EmptyGeom.INSTANCE, Elements.NONE, new FlattenedProps(new IPrimProps[0]));
    private final ArrayList<IGeom> d_geoms = new ArrayList();
    private final PropsBuilder d_props = new PropsBuilder();
    private final ElementsBuilder d_elements = new ElementsBuilder();

    public void add(Rep rep) {
        this.add(rep.geom, rep.props, rep.elements);
    }

    public void add(IGeom geom, IPrimProps props, IPropertySet elements) {
        this.add(geom, new UniformProps(props), elements);
    }

    public void add(IGeom geom, IPropsSrc props, IPropertySet elements) {
        if (geom == EmptyGeom.INSTANCE) {
            return;
        }
        int numPrims = geom.getNumPrims(7);
        if (numPrims == 0) {
            return;
        }
        this.d_geoms.add(geom);
        this.d_props.add(props, numPrims);
        this.d_elements.add(elements, numPrims);
    }

    public Rep finish() {
        IGeom geom = GeomUtil.group(this.d_geoms);
        if (geom == EmptyGeom.INSTANCE) {
            return EMPTY_REP;
        }
        IPropsSrc props = this.d_props.finalizeProps();
        IPropertySet elements = this.d_elements.finish();
        return new Rep(geom, elements, props);
    }

    public static Rep merge(Collection<Rep> dgeoms) {
        if (dgeoms.isEmpty()) {
            return EMPTY_REP;
        }
        if (dgeoms.size() == 1) {
            return dgeoms.iterator().next();
        }
        Rep nonEmptyDg = null;
        DisplayGeomBuilder builder = null;
        for (Rep dg : dgeoms) {
            if (dg == EMPTY_REP) continue;
            if (nonEmptyDg == null) {
                nonEmptyDg = dg;
                continue;
            }
            if (builder == null) {
                builder = new DisplayGeomBuilder();
                builder.add(nonEmptyDg);
            }
            builder.add(dg);
        }
        if (builder == null && nonEmptyDg == null) {
            return EMPTY_REP;
        }
        if (builder == null) {
            return nonEmptyDg;
        }
        return builder.finish();
    }

    public static class Rep {
        public final IGeom geom;
        public final IPropsSrc props;
        public final IPropertySet elements;

        public Rep(IGeom geom, IPropertySet elements, IPropsSrc props) {
            this.geom = geom;
            this.props = props;
            this.elements = elements;
        }

        public DisplayGeom toDisplay() {
            if (this.geom == EmptyGeom.INSTANCE) {
                return DisplayGeom.EMPTY;
            }
            return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(this.geom, this.elements), this.props);
        }
    }
}

