/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.license3;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.SplashScreen;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiURLLabel;
import thunderheadeng.license3.LicenseManager;

public class LicensePrompt
extends guiDialog {
    private final LicenseManager d_lm;
    private JProgressBar progressBar;
    private guiLabel labelImg;
    private guiURLLabel labelLink;
    private guiLabel labelHeader;
    private guiLabel labelWelcome;
    private guiLabel labelDays;
    private guiLabel labelNotice;
    private JButton btnLicense;
    private JButton btnOK;

    public LicensePrompt(JFrame frmParent, LicenseManager lm, Type promptType, String productName, String urlLink, int reminderLimit, Icon icon, final Action registerAction) {
        super((Window)frmParent, String.format(Intl.intl("%s License"), productName), 0);
        String notice;
        String welcome;
        guiPanel dlgPane = this.getDialogPane();
        dlgPane.setLayout(new BorderLayout());
        String header = Intl.intl("Welcome");
        if (promptType == Type.PURCHASE) {
            welcome = String.format(Intl.intl("<html>Thank you for evaluating %1$s.<br><br>If you have already purchased %1$s, please enter your site<br>code using the <b>Register</b> button below.</html>"), productName);
            notice = String.format(Intl.intl("<html><b>NOTICE:</b>&nbsp;&nbsp;%s will stop functioning when your license expires.</html>"), productName);
        } else {
            welcome = String.format(Intl.intl("<html>Thank you for using %1$s.<br><br>To renew your %1$s license, click the <b>Register</b> button below.</html>"), productName);
            notice = String.format(Intl.intl("<html><b>NOTICE:</b>&nbsp;&nbsp;%s will stop functioning when your license expires.</html>"), productName);
        }
        int daysLeft = lm.getDaysRemaining();
        this.d_lm = lm;
        this.labelHeader = new SmoothLabel(header);
        this.labelHeader.setFont(this.labelHeader.getFont().deriveFont(1, 18.0f));
        this.btnLicense = new JButton(Intl.intl("Register"));
        this.labelWelcome = new guiLabel(welcome);
        this.labelNotice = new guiLabel(notice);
        this.btnLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                registerAction.actionPerformed(evt);
                LicensePrompt.this.setVisible(false);
            }
        });
        this.labelImg = new guiLabel(icon);
        this.labelLink = new guiURLLabel(urlLink);
        this.labelLink.setHorizontalAlignment(0);
        this.progressBar = new JProgressBar(0, reminderLimit);
        this.progressBar.setValue(reminderLimit - daysLeft);
        this.progressBar.setStringPainted(false);
        this.progressBar.setForeground(Color.BLUE);
        this.btnOK = new JButton(Intl.intl("OK"));
        this.btnOK.setPreferredSize(this.btnLicense.getPreferredSize());
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicensePrompt.this.setVisible(false);
            }
        });
        guiPanel left = new guiPanel(new GridBagLayout());
        if (icon != null) {
            GridBagUtil.add(left, this.labelImg, 0, 0, 1, 1, 0, 0, 12, 0, 0, 1.0, 0.0);
            GridBagUtil.add(left, this.labelLink, 0, 1, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0);
        }
        guiLabel remaining = new guiLabel(String.valueOf(daysLeft) + " days left");
        remaining.setHorizontalAlignment(0);
        guiPanel days = new guiPanel(new GridBagLayout());
        GridBagUtil.add(days, new guiLabel(String.valueOf(0)), 0, 0, 1, 1, 0, 0, 0, 0);
        GridBagUtil.add(days, remaining, 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.add(days, new guiLabel(String.valueOf(reminderLimit)), 2, 0, 1, 1, 0, 0, 0, 0);
        guiPanel right = new guiPanel(new GridBagLayout());
        GridBagUtil.add(right, this.labelHeader, 0, 0, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 18);
        GridBagUtil.add(right, this.labelWelcome, 0, 1, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 18);
        GridBagUtil.add(right, this.labelNotice, 0, 2, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 18);
        GridBagUtil.add(right, days, 0, 3, 1, 1, 0, 0, 2, 0, 2, 0.0, 0.0, 15);
        GridBagUtil.add(right, this.progressBar, 0, 4, 1, 1, 0, 0, 12, 0, 2, 0.0, 0.0, 11);
        if (icon == null) {
            GridBagUtil.add(right, this.labelLink, 0, 5, 1, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 18);
        }
        GridBagUtil.addGlue(right);
        JComponent[] buttons = new JButton[]{this.btnLicense, this.btnOK};
        this.setButtons(buttons);
        guiPanel top = new guiPanel(new GridBagLayout());
        if (icon != null) {
            GridBagUtil.add(top, left, 0, 0, 1, 1, 0, 0, 0, 18, 0, 0.0, 0.0, 18);
        }
        GridBagUtil.add(top, right, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.0, 18);
        Box all = new Box(1);
        all.add(top);
        all.add(new JSeparator(0));
        dlgPane.add((Component)all, "Center");
    }

    public static void checkRenewPrompt(JFrame parent, LicenseManager lm, String productName, String urlLink, Icon icon, Action registerAction, int reminderLimit, SplashScreen splash) {
        boolean underLimit;
        boolean userHasBeenNotified = false;
        assert (lm.isAuthorized());
        int numLeft = lm.getDaysRemaining();
        boolean bl = underLimit = numLeft <= reminderLimit && numLeft != 0;
        if (!userHasBeenNotified && underLimit && !lm.isRoaming()) {
            userHasBeenNotified = true;
            if (splash != null) {
                splash.hideSplash();
            }
            assert (lm.isAuthorized());
            LicensePrompt prompt = new LicensePrompt(parent, lm, Type.RENEW, productName, urlLink, reminderLimit, icon, registerAction);
            prompt.doModal();
        }
    }

    private class SmoothLabel
    extends guiLabel {
        public SmoothLabel(String txt) {
            super(txt);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paintComponent(g);
        }
    }

    public static enum Type {
        PURCHASE,
        RENEW;

    }
}

