/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.license3;

import com.reprisesoftware.rlm.RlmAvailableProduct;
import com.reprisesoftware.rlm.RlmException;
import com.reprisesoftware.rlm.RlmHandle;
import com.reprisesoftware.rlm.RlmLicense;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.license3.ActivationDlg;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class LicenseManager {
    private static final Logger LOGGER = Logger.getLogger(LicenseManager.class.getName());
    private final String d_productName;
    private final String d_license;
    private final String d_lmVersion;
    private final Collection<String> d_possibleOptions;
    private RlmHandle d_rlm = null;
    private RlmLicense d_product = null;
    private Map<String, RlmLicense> d_options = new HashMap<String, RlmLicense>();
    private String d_lastError = "";
    private Timer d_timer;
    private int d_strikes = 0;
    private Map<RlmLicense, String> d_acquired;

    public LicenseManager(String productName, String license, String lmVersion, Collection<String> possibleOptions) {
        this.d_productName = productName;
        this.d_lmVersion = lmVersion;
        this.d_license = license;
        this.d_possibleOptions = possibleOptions;
        this.d_acquired = new LinkedHashMap<RlmLicense, String>();
    }

    public synchronized boolean startFromPrefs(TeciProps prefs, TypedProp<String> dirPref, TypedProp<String> serverPref) {
        String location = prefs.getString(ActivationDlg.PROP_LOCATION);
        boolean useServerPref = "not_set".equals(location) || "server".equals(location);
        boolean useFilePref = "not_set".equals(location) || "file".equals(location);
        String server = prefs.getString(serverPref);
        if (useServerPref && !server.isEmpty() && this.startLM(server)) {
            return true;
        }
        String licFolder = prefs.getString(dirPref);
        return useFilePref && this.startLM(licFolder);
    }

    private String toString(RlmException e) {
        switch (e.getCode()) {
            case -171: 
            case -170: {
                return "No authorization for product (-1)";
            }
        }
        return e.getMessage();
    }

    public synchronized boolean startLM(String licenseLoc) {
        RlmLicense product;
        block22: {
            RlmHandle h = null;
            product = null;
            String str1 = "LICENSE theng theng_product 2017.12 18-nov-0 uncounted hostid=ANY _ck=2d1efc635e sig=\"60P0451D3FDR3D9YG5E1QAGHGC9WDA92MGQYVA022H04DG3PM9JQD7GAH86TRTYGWXSB9PE1MC\"";
            String str2 = "LICENSE theng theng_product 2019.09 25-jul-0 uncounted hostid=ANY  issued=25-jun-2009 _ck=2b1ed5b75c sig=\"60P04535AJPAK1QG02Y69369W3YJW  KC4QYE0CNG22G8UM0YJGC62BY3TTNE6JXF7RFFATMA428\"";
            String str3 = "LICENSE theng theng_product 2017.12 18-nov-0 uncounted hostid=ANY _ck=2d1efc635e sig=\"60P0451D3FDR3D9YG5E1XAGHGC9WDA92MGQYVA022H04DG3PM9JQD7GAH86TRTYGWXSB9PE1MC\"";
            String str4 = "LICENSE theng theng_product 2019.10 25-jul-0 uncounted hostid=ANY  issued=25-jun-2009 _ck=2b1ed5b75c sig=\"60P04535AJPAK1QG02Y69369W3YJW  KC4QYE0CNG22G8UM0YJGC62BY3TTNE6JXF7RFFATMA428\"";
            try {
                h = new RlmHandle(null, null, String.format("<%s>", str1));
                h.enableLogging(0);
                product = new RlmLicense(h, "theng_product", "2015.2", 1);
                product.checkin();
            }
            catch (RlmException e) {
                this.logAndReport();
                this.getErrFunc().accept(new RuntimeException(new ServiceConfigurationError("RLM Service")));
            }
            try {
                h = new RlmHandle(null, null, String.format("<%s>", str2));
                h.enableLogging(0);
                product = new RlmLicense(h, "theng_product", "2019.08", 1);
                product.checkin();
            }
            catch (RlmException e) {
                this.logAndReport();
                this.getErrFunc().accept(new RuntimeException(new ServiceConfigurationError("RLM Service")));
            }
            try {
                h = new RlmHandle(null, null, String.format("<%s>", str3));
                h.enableLogging(0);
                product = new RlmLicense(h, "theng_product", "2015.2", 1);
                product.checkin();
                this.logAndReport();
                this.getErrFunc().accept(new RuntimeException(new ServiceConfigurationError("RLM Service")));
            }
            catch (RlmException e) {
                // empty catch block
            }
            try {
                h = new RlmHandle(null, null, String.format("<%s>", str4));
                h.enableLogging(0);
                product = new RlmLicense(h, "theng_product", "2019.08", 1);
                product.checkin();
                this.logAndReport();
                this.getErrFunc().accept(new RuntimeException(new ServiceConfigurationError("RLM Service")));
            }
            catch (RlmException e) {
                // empty catch block
            }
            if (licenseLoc == null) {
                licenseLoc = "";
            }
            try {
                LOGGER.log(Level.CONFIG, "*** Using " + licenseLoc);
                h = new RlmHandle(licenseLoc, ".", this.d_license);
            }
            catch (RlmException e) {
                LOGGER.log(Level.SEVERE, "RLM Handle Exception...");
                LOGGER.log(Level.SEVERE, e.toString(), e);
                this.d_lastError = this.toString(e);
                return false;
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.log(Level.SEVERE, "RLM Handle Exception...");
                LOGGER.log(Level.SEVERE, e.toString(), e);
                this.d_lastError = e.getMessage();
                return false;
            }
            this.d_rlm = h;
            try {
                product = new RlmLicense(this.d_rlm, this.d_productName, this.d_lmVersion, 1);
            }
            catch (RlmException e) {
                LOGGER.log(Level.SEVERE, "RLM License Exception...");
                LOGGER.log(Level.SEVERE, e.toString(), e);
                this.d_lastError = this.toString(e);
                return false;
            }
            if ("".equals(product.getHostID())) {
                str1 = "LICENSE theng theng_product 2017.12 18-nov-2017 uncounted hostid=11111111 customer=\"Free Trial\" issued=20-oct-2017 replace _ck=c75e3ecd93 sig=\"60P04535R9KQ9XJDU769EJKF5RHKH0EU7ESTJPG22HYA5MKK2KJ9FD37FQMVXGABW849QDCEHV\"";
                str2 = "LICENSE theng theng_product 2017.12 18-nov-2017 uncounted  hostid=22222222 customer=\"Free Trial\" issued=20-oct-2017 replace _ck=c7663e6004 sig=\"60P0451HCWQHY0AA5YCMRXUU9G53HGXNKKR3R4022HA4U197 E7NNYH54WJMCJX8SWA8ST21PE4\"";
                str3 = "LICENSE theng theng_product 2017.12 18-nov-2017 uncounted hostid=22222222 customer=\"Free Trial\" issued=20-oct-2017 replace _ck=c75e3ecd93 sig=\"60P04535R9KQ9XJDU769EJKF5RHKH0EU7ESTJPG22HYA5MKK2KJ9FD37FQMVXGABW849QDCEHV\"";
                str4 = "LICENSE theng theng_product 2017.12 18-nov-2017 uncounted  hostid=11111111 customer=\"Free Trial\" issued=20-oct-2017 replace _ck=c7663e6004 sig=\"60P0451HCWQHY0AA5YCMRXUU9G53HGXNKKR3R4022HA4U197 E7NNYH54WJMCJX8SWA8ST21PE4\"";
                try {
                    if (!product.authCheck(str1) || !product.authCheck(str2)) {
                        this.logAndReport();
                        this.getErrFunc().accept(new RuntimeException(new ServiceConfigurationError("RLM Service")));
                    }
                }
                catch (Throwable t) {
                    this.logAndReport();
                    this.getErrFunc().accept(new RuntimeException(new ServiceConfigurationError("RLM Service")));
                }
                try {
                    if (product.authCheck(str3) || product.authCheck(str4)) {
                        this.logAndReport();
                        this.getErrFunc().accept(new RuntimeException(new ServiceConfigurationError("RLM Service")));
                    }
                }
                catch (Throwable t) {
                    if (t instanceof RlmException && ((RlmException)t).getCode() == -5) break block22;
                    this.logAndReport();
                    this.getErrFunc().accept(new RuntimeException(new ServiceConfigurationError("RLM Service")));
                }
            }
        }
        this.d_product = product;
        if (this.d_product.getHostID().equals("")) {
            LOGGER.log(Level.FINER, "Starting timer");
            this.d_strikes = 0;
            this.d_timer = new Timer(true);
            this.d_timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    LicenseManager.this.checkServerStatus();
                }
            }, 60000L, 60000L);
        }
        return true;
    }

    private synchronized void checkServerStatus() {
        block9: {
            int status = -1;
            if (this.d_product != null) {
                try {
                    status = this.d_product.getAttrHealth();
                }
                catch (RlmException ex) {
                    LOGGER.log(Level.SEVERE, "RLM License Exception...");
                    LOGGER.log(Level.SEVERE, ex.toString(), ex);
                }
            }
            if (status != 0 && status != -25) {
                LOGGER.log(Level.INFO, "License Server Down -- status: " + status);
                ++this.d_strikes;
                if (this.d_strikes >= 3) {
                    this.checkin();
                    try {
                        this.d_product = new RlmLicense(this.d_rlm, this.d_productName, this.d_lmVersion, 1);
                    }
                    catch (RlmException e) {
                        LOGGER.log(Level.SEVERE, "RLM License Exception...");
                        LOGGER.log(Level.SEVERE, e.toString(), e);
                        this.d_lastError = e.getMessage();
                        JOptionPane.showMessageDialog(null, Intl.intl("Lost floating license -- closing program."), String.format(Intl.intl("%s (Unlicensed)"), this.d_productName), 0);
                        LOGGER.log(Level.INFO, "Licensing failure. Shutting down.");
                        if (Application.getApp() != null) {
                            SwingUtilities.invokeLater(() -> Application.getApp().quit(false));
                            break block9;
                        }
                        System.exit(0);
                    }
                }
            } else {
                this.d_strikes = 0;
            }
        }
    }

    private static void reportAbuse(final String prod, final String vers, final String event) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        String strUrl = "http://www.thunderheadeng.com/runlog.php?prod=" + prod + "&vers=" + vers + "&event=" + event;
                        URL url = new URL(strUrl);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.getResponseCode();
                    }
                    catch (Exception e) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)e.getMessage());
                    }
                }
            }
        });
        t.start();
    }

    public String getHostID(int type) {
        return this.d_rlm.getAllHostIDs(type)[0].trim();
    }

    public String getHostIDs() {
        if (this.d_rlm == null) {
            return Intl.intl("unavailable");
        }
        String[] ethers = this.d_rlm.getAllHostIDs(3);
        String ether = "";
        for (int i = 0; i < ethers.length; ++i) {
            if (i > 0) {
                ether = ether + " ";
            }
            ether = ether + ethers[i].trim();
        }
        return "hostid=" + this.getHostID(1) + "\n" + "ether=" + ether + "\n" + this.getHostID(6);
    }

    public String getEth0(String def) {
        String[] ether = this.d_rlm.getAllHostIDs(3);
        if (ether != null && 0 < ether.length) {
            return ether[0];
        }
        return def;
    }

    public String getLicenseLocation() {
        return this.d_product == null ? "" : this.d_product.getLFPath();
    }

    public boolean isAuthorized() {
        return this.d_product != null && this.d_product.goodOnce();
    }

    public boolean isRoaming() {
        return this.d_product != null && this.d_product.isRoaming();
    }

    public boolean inQueue() {
        if (this.d_product != null) {
            try {
                if (this.d_product.status() == -25) {
                    return true;
                }
            }
            catch (RlmException e) {
                LOGGER.log(Level.SEVERE, "RLM License Exception...");
                LOGGER.log(Level.SEVERE, e.toString(), e);
                return false;
            }
        }
        return false;
    }

    public int getDaysRemaining() {
        return this.d_product.daysToExpiration();
    }

    private RlmAvailableProduct getProduct() throws NoAvailableProductsException {
        Vector prod = this.d_rlm.getAvailableProducts(this.d_productName, this.d_lmVersion);
        if (prod == null) {
            throw new NoAvailableProductsException();
        }
        return (RlmAvailableProduct)prod.get(0);
    }

    public String getDescription() {
        String desc = Intl.intl("unknown error");
        if (this.d_rlm == null || this.d_product == null) {
            return this.d_lastError;
        }
        if (this.isAuthorized() || this.inQueue()) {
            try {
                RlmAvailableProduct psProd = this.getProduct();
                desc = "";
                int maxcount = psProd.getCount();
                LOGGER.log(Level.FINER, "Host ID: " + this.d_product.getHostID());
                String type = this.d_product.getHostID().equals("") ? Intl.intl("Floating") : Intl.intl("Node-Locked");
                String usageCount = "";
                usageCount = this.d_product.isRoaming() ? Intl.intl("Roaming") : (maxcount == 0 ? Intl.intl("Unlimited") : String.format(Intl.intl("%1$d of %2$d"), psProd.getCurrentInUse(), maxcount));
                desc = desc + String.format(Intl.intl("Usage: %1$s, %2$s\n"), type, usageCount);
                int days = this.d_product.daysToExpiration();
                String daysText = days == 0 ? Intl.intl("Unlimited") : Integer.toString(days);
                desc = desc + String.format(Intl.intl("Days Remaining: %s\n"), daysText);
                desc = desc + String.format(Intl.intl("Maintenance Expires: %s\n"), this.d_product.getVersion());
                String options = "";
                for (String option : this.d_possibleOptions) {
                    LicenseStatus status = this.getAvailableProduct(option);
                    if (status != LicenseStatus.AVAILABLE && status != LicenseStatus.IN_USE) continue;
                    if (!options.isEmpty()) {
                        options = options + ", ";
                    }
                    options = options + option;
                }
                if (!options.isEmpty()) {
                    desc = desc + "\n" + String.format(Intl.intl("Options: %s\n"), options);
                }
                LOGGER.log(Level.FINER, "ROAM: " + this.d_product.isRoaming());
            }
            catch (NoAvailableProductsException e) {
                desc = Intl.intl("Unable to communicate with license server.");
            }
        }
        return desc;
    }

    public String getLastError() {
        return this.d_lastError;
    }

    private synchronized void checkin() {
        if (this.d_product != null) {
            this.d_product.checkin();
            this.d_product = null;
        }
        for (RlmLicense lic : this.d_options.values()) {
            lic.checkin();
        }
        this.d_options.clear();
    }

    public synchronized void closeLM() {
        if (this.d_timer != null) {
            this.d_timer.cancel();
        }
        this.checkin();
        if (this.d_rlm != null) {
            this.d_rlm.close();
            this.d_rlm = null;
        }
        this.d_acquired.clear();
    }

    public LicenseStatus getAvailableProduct(String product) {
        if (this.d_rlm == null) {
            return LicenseStatus.NOT_FOUND;
        }
        Vector available = this.d_rlm.getAvailableProducts(product, this.d_lmVersion);
        if (available == null) {
            return LicenseStatus.NOT_FOUND;
        }
        Iterator iterator = available.iterator();
        if (iterator.hasNext()) {
            RlmAvailableProduct productInfo = (RlmAvailableProduct)iterator.next();
            int count = productInfo.getCount();
            int inUse = productInfo.getCurrentInUse();
            return inUse < count ? LicenseStatus.AVAILABLE : LicenseStatus.IN_USE;
        }
        return LicenseStatus.NOT_FOUND;
    }

    public boolean acquireLicense(String product) {
        RlmLicense already = this.findAcquiredLicenseByProduct(product);
        if (already != null) {
            LOGGER.log(Level.FINER, String.format("acquireLicese(%s): %s%n", product, "License already acquired."));
            return true;
        }
        try {
            RlmLicense license = new RlmLicense(this.d_rlm, product, this.d_lmVersion, 1);
            if (license.status() != 0) {
                LOGGER.log(Level.WARNING, String.format("aquireLicense(product=%s) - failed with status code %s%n", product, license.status()));
                license.checkin();
                return false;
            }
            LOGGER.log(Level.FINER, String.format("acquireLicese(%s): %s%n", product, "success"));
            this.d_acquired.put(license, product);
            return true;
        }
        catch (RlmException e) {
            e.printStackTrace();
            return false;
        }
    }

    public RlmLicense findAcquiredLicenseByProduct(String product) {
        for (Map.Entry<RlmLicense, String> entry : this.d_acquired.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(product)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean releaseAcquiredLicense(RlmLicense license) {
        String product = license.getProduct();
        license.checkin();
        boolean success = this.d_acquired.remove(license) != null;
        LOGGER.log(Level.FINER, String.format("releaseAcquiredLicense(%s): %s%n", product, success ? "success" : "failed"));
        return success;
    }

    public Collection<RlmLicense> getAcquiredLicenses() {
        return this.d_acquired.keySet();
    }

    protected RlmLicense getProductLicense() {
        return this.d_product;
    }

    public String getLicenseVersion() {
        return this.getProductLicense().getVersion();
    }

    public boolean isOptionAvailable(String option) throws Exception {
        throw new Exception();
    }

    private void logAndReport() {
        if (Application.getApp() != null) {
            TeciProps props = Application.getApp().getPrefs();
            boolean logged = props.getBoolean("runlog", false);
            if (!logged) {
                LicenseManager.reportAbuse(this.d_productName, this.d_lmVersion, "firstrun");
                props.set("runlog", (Object)true);
            } else {
                LicenseManager.reportAbuse(this.d_productName, this.d_lmVersion, "run");
            }
        }
    }

    private Consumer<Throwable> getErrFunc() {
        return t -> new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (Application.getApp() != null) {
                    SwingUtilities.invokeLater(() -> {
                        JFrame mf = Application.getApp().getMainFrame();
                        if (!mf.getTitle().startsWith(Intl.intl("(illegal software, no license)"))) {
                            mf.setTitle(Intl.intl("(illegal software, no license) " + mf.getTitle()));
                        }
                    });
                }
            }
        }, (long)(2000.0 * Math.random()), (long)(2000.0 * Math.random()));
    }

    public class NoAvailableProductsException
    extends Exception {
    }

    public static enum LicenseStatus {
        AVAILABLE,
        NOT_FOUND,
        IN_USE;

    }
}

