/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.legacy.v14.geometry.objs;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import thunderheadeng.geometry.objs.ClosedLinearCurve;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.util.Pair;

public class WallGeom
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final double NONLINEAR_CURVE_TOL = 0.001;
    private ICurve refCurve;
    private WallGeom.Alignment alignment;
    private double thickness;
    private double height;

    public Object readResolve() throws ObjectStreamException {
        Pair<Point3d[], Boolean> refVerts = this.getReferenceVerts();
        boolean wrapped = WallGeom.isWrapped((Point3d[])refVerts.v1);
        if (wrapped) {
            return new thunderheadeng.geometry.objs.WallGeom(new ClosedLinearCurve(new PolyLine((Point3d[])refVerts.v1)), this.alignment, this.thickness, this.height);
        }
        ICurve resultCurve = (Boolean)refVerts.v2 == false ? this.refCurve : (((Point3d[])refVerts.v1).length == 2 ? new LineSeg(((Point3d[])refVerts.v1)[0], ((Point3d[])refVerts.v1)[1]) : new PolyLine((Point3d[])refVerts.v1));
        return new thunderheadeng.geometry.objs.WallGeom(resultCurve, this.alignment, this.thickness, this.height);
    }

    private static boolean isWrapped(Point3d[] refVerts) {
        return refVerts.length >= 3 && refVerts[0].epsilonEquals((Tuple3d)refVerts[refVerts.length - 1], 1.0E-9);
    }

    private Pair<Point3d[], Boolean> getReferenceVerts() {
        ArrayList<Point3d> refVerts;
        boolean modified = false;
        if (this.refCurve instanceof ILinearCurve) {
            ILinearCurve lc = (ILinearCurve)this.refCurve;
            refVerts = new ArrayList<Point3d>(lc.getNumVerts());
            Point3d prev = null;
            for (int m = 0; m < lc.getNumVerts(); ++m) {
                Point3d p = lc.getVert(m);
                if (prev == null) {
                    refVerts.add(p);
                } else if (!WallGeom.equal2d(prev, p)) {
                    refVerts.add(p);
                } else {
                    modified = true;
                }
                prev = p;
            }
        } else {
            Mesh segMesh = this.refCurve.getSegments(0.001);
            if (segMesh.indices.length == 0) {
                return new Pair<Point3d[], Boolean>(new Point3d[0], false);
            }
            refVerts = new ArrayList(segMesh.indices.length / 2 - 1);
            Point3d prev = null;
            for (int m = 0; m < segMesh.indices.length; m += 2) {
                Point3d p = segMesh.vertices[segMesh.indices[m]];
                if (prev == null || !WallGeom.equal2d(prev, p)) {
                    refVerts.add(p);
                }
                prev = p;
            }
            Point3d last = segMesh.vertices[segMesh.indices[segMesh.indices.length - 1]];
            if (prev == null || !WallGeom.equal2d(prev, last)) {
                refVerts.add(last);
            }
        }
        Point3d[] verts = refVerts.toArray(new Point3d[refVerts.size()]);
        return new Pair<Point3d[], Boolean>(verts, modified);
    }

    private static boolean equal2d(Point3d p1, Point3d p2) {
        return p1.x == p2.x && p1.y == p2.y;
    }
}

