/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.legacy.v12.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.function.Predicate;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class Filters {
    private static <T> boolean setsEqual(T[] set1, T[] set2) {
        if (set1.length != set2.length) {
            return false;
        }
        for (T obj1 : set1) {
            if (Filters.contains(set2, obj1)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean contains(T[] set, T obj) {
        for (T obj1 : set) {
            if (!theUtil.equal(obj1, obj)) continue;
            return true;
        }
        return false;
    }

    public static class CachedFilter<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        private Predicate<T> d_baseFilter;

        public boolean equals(Object obj) {
            return obj instanceof CachedFilter && ((CachedFilter)obj).d_baseFilter.equals(this.d_baseFilter);
        }

        public int hashCode() {
            return 0x15623 ^ this.d_baseFilter.hashCode();
        }

        private Object readResolve() throws ObjectStreamException {
            return Predicates.cache(this.d_baseFilter);
        }
    }

    public static class MultiCompoundFilter<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<T>[] filters;
        public Logic logic;

        public int hashCode() {
            int hash = this.logic.hashCode();
            for (Predicate<T> filter : this.filters) {
                hash += filter.hashCode();
            }
            return hash ^= 0x92548AA3;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MultiCompoundFilter && ((MultiCompoundFilter)obj).logic == this.logic && Filters.setsEqual(((MultiCompoundFilter)obj).filters, this.filters);
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.logic) {
                case ACCEPT_ALL: {
                    return Predicates.and(this.filters);
                }
            }
            return Predicates.or(this.filters);
        }
    }

    public static class CompoundFilter<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<? super T> f1;
        public Predicate<? super T> f2;
        public Logic logic;

        public int hashCode() {
            return 0x1692362 ^ this.logic.hashCode() + this.f1.hashCode() + this.f2.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof CompoundFilter && ((CompoundFilter)obj).logic == this.logic && (((CompoundFilter)obj).f1.equals(this.f1) && ((CompoundFilter)obj).f2.equals(this.f2) || ((CompoundFilter)obj).f1.equals(this.f2) && ((CompoundFilter)obj).f2.equals(this.f1));
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.logic) {
                case ACCEPT_ALL: {
                    return Predicates.and(this.f1, this.f2);
                }
            }
            return Predicates.or(this.f1, this.f2);
        }
    }

    public static class InvertFilter<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<T> filter;

        public int hashCode() {
            return 0x61234F3 ^ this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof InvertFilter && ((InvertFilter)obj).filter.equals(this.filter);
        }

        private Object readResolve() throws ObjectStreamException {
            return new Predicates.Negate<T>(this.filter);
        }
    }

    public static enum Logic {
        ACCEPT_ANY,
        ACCEPT_ALL;

    }
}

