/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.streamsrc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import thunderheadeng.io.DecryptInputStream;
import thunderheadeng.io.TeciEncrypt;
import thunderheadeng.io.streamsrc.IFilterStreamSrc;
import thunderheadeng.io.streamsrc.IStreamSrc;

public class DecryptStreamSrc
implements IFilterStreamSrc,
Serializable {
    private static final long serialVersionUID = 0L;
    public final IStreamSrc baseSrc;
    private transient long d_headerRetrievalTime = -1L;
    private transient DecryptInputStream.Header d_encryptHeader;

    public DecryptStreamSrc(IStreamSrc baseSrc) {
        this.baseSrc = baseSrc;
        this.d_encryptHeader = null;
    }

    @Override
    public IStreamSrc getBaseSource() {
        return this.baseSrc;
    }

    @Override
    public long getSize(int options) throws IOException {
        if ((options & 1) == 0) {
            DecryptInputStream.Header header = this.getEncryptionHeader(0);
            if (header.type.encrypted) {
                return header.dataLen;
            }
        }
        return this.baseSrc.getSize(options);
    }

    @Override
    public InputStream open(int options) throws IOException {
        if ((options & 1) == 1) {
            return this.baseSrc.open(options);
        }
        DecryptInputStream.Header header = this.getEncryptionHeader(options);
        InputStream stream = this.baseSrc.open(options);
        if (header.type.encrypted) {
            if (!stream.markSupported()) {
                stream = new BufferedInputStream(stream);
            }
            stream = new DecryptInputStream(stream);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecryptInputStream.Header getEncryptionHeader(int openOptions) {
        long srcModTime = this.baseSrc.getModTime();
        if (this.d_encryptHeader == null || srcModTime != this.d_headerRetrievalTime) {
            DecryptInputStream.Header header = new DecryptInputStream.Header(TeciEncrypt.Type.UNENCRYPTED, 0L);
            InputStream is = null;
            try {
                is = this.baseSrc.open(openOptions);
                if (!is.markSupported()) {
                    is = new BufferedInputStream(is);
                }
                header = DecryptInputStream.getEncryptionHeader(is);
            }
            catch (IOException iOException) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.d_encryptHeader = header;
            this.d_headerRetrievalTime = srcModTime;
        }
        return this.d_encryptHeader;
    }

    @Override
    public long getModTime() {
        return this.baseSrc.getModTime();
    }

    @Override
    public boolean isLocal() {
        return this.baseSrc.isLocal();
    }

    @Override
    public IStreamSrc refilter(IStreamSrc src) {
        return new DecryptStreamSrc(this.baseSrc.refilter(src));
    }
}

