/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.nativexfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeKeyedObject;

public class NativeObjectHelper
extends NativeKeyedObject {
    private boolean d_nativeDirty = false;
    private INativeObject d_baseObject;

    public NativeObjectHelper(INativeObject baseObj) {
        this.d_baseObject = baseObj;
    }

    public void nativeConstructed(Class clazz) {
        if (clazz.equals(this.d_baseObject.resolveNativeClass())) {
            this.markNativeDirty();
        }
    }

    public void createPeer() {
        Native.manager.createPeer(this.d_baseObject.resolveNativeClass(), this.getKey());
    }

    @Override
    protected void finalize() throws Throwable {
        Native.manager.deletePeer(this.d_baseObject);
        super.finalize();
    }

    protected INativeObject getBaseObject() {
        return this.d_baseObject;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.createPeer();
    }

    public Object clone(INativeObject baseObj) {
        NativeObjectHelper clone = (NativeObjectHelper)super.clone();
        clone.d_baseObject = baseObj;
        clone.createPeer();
        clone.markNativeDirty();
        return clone;
    }

    public void markNativeDirty() {
        this.d_nativeDirty = true;
    }

    public void markNativeClean() {
        this.d_nativeDirty = false;
    }

    public final boolean isNativeDirty() {
        return this.d_nativeDirty;
    }
}

