/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.nativexfer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import thunderheadeng.io.nativexfer.ABufferedNativeStream;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativelyMirrored;
import thunderheadeng.io.nativexfer.JNIException;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.util.KeyGenerator;
import thunderheadeng.util.Keyable;

public class NativeManager
extends ABufferedNativeStream {
    protected long d_peerObj;
    private static final byte COMMAND_CREATE_OBJECT = 0;
    private static final byte COMMAND_DELETE_OBJECT = 1;
    private static final byte COMMAND_UPDATE_OBJECT = 2;
    private static final byte COMMAND_EXEC_METHOD = 3;
    private static final byte COMMAND_EXEC_STATIC_METHOD = 4;
    private static final byte COMMAND_CONNECT_PEERS = 5;
    private static final byte COMMAND_STATUS_COMPLETE = 0;
    private static final byte COMMAND_STATUS_INCOMPLETE = 1;
    private int d_numCommands = 0;
    private byte d_commandStatus = 1;
    private int d_lastCommandPosition = 0;
    private int d_firstCommandLengthB = 0;
    private int d_lastCommandLengthB = 0;
    private final Map<Class<? extends INativeObject>, Integer> d_classKeyMap = new HashMap<Class<? extends INativeObject>, Integer>();
    private final Map<Integer, Class<? extends INativeObject>> d_keyClassMap = new HashMap<Integer, Class<? extends INativeObject>>();
    private int d_classKeyIt = 0;
    private KeyGenerator d_keyGenerator = new KeyGenerator();
    private int d_numFlushes = 0;
    private final ExecutorService d_executor = Executors.newSingleThreadExecutor();
    private static final Map<Integer, Constructor<? extends Keyable>> s_nativeConstructors = new HashMap<Integer, Constructor<? extends Keyable>>();

    private native void registerClassKey(String var1, int var2);

    private final native void dispatch(ByteBuffer var1, ByteBuffer var2, int var3, byte var4, int var5, int var6) throws JNIException;

    public NativeManager() {
        this(0x100000, 0x100000);
    }

    public NativeManager(int writeBufferCapacity, int readBufferCapacity) {
        super(writeBufferCapacity, readBufferCapacity);
    }

    public KeyGenerator getKeyGenerator() {
        return this.d_keyGenerator;
    }

    private Class<? extends INativeObject> getClassForKey(int classKey) {
        return this.d_keyClassMap.get(classKey);
    }

    public ExecutorService getDispatchExecutor() {
        return this.d_executor;
    }

    private static int sRegisterClass(Class<? extends INativeObject> clazz) {
        return Native.manager.registerClass(clazz);
    }

    private int registerClass(Class<? extends INativeObject> clazz) {
        Integer existing = this.d_classKeyMap.get(clazz);
        if (existing != null) {
            return existing;
        }
        int key = this.d_classKeyIt++;
        this.d_classKeyMap.put(clazz, key);
        this.d_keyClassMap.put(key, clazz);
        this.registerClassKey(clazz.getCanonicalName(), key);
        return key;
    }

    private final void beginCommand(byte command) {
        this.lockWriteBuffer();
        this.writeByte(command);
        this.d_lastCommandPosition = this.getWritePosition() - 1;
        this.d_commandStatus = 1;
        ++this.d_numCommands;
    }

    private final void endCommand() {
        this.d_commandStatus = 0;
        if (this.d_numCommands == 1) {
            this.d_firstCommandLengthB = this.getWritePosition() - this.d_lastCommandPosition;
        }
        this.markStrongRefsFinished();
        this.unlockWriteBuffer();
    }

    @Override
    public void lockWriteBuffer() {
        this.d_keyGenerator.beginReserveKeys();
        super.lockWriteBuffer();
    }

    @Override
    public void unlockWriteBuffer() {
        super.unlockWriteBuffer();
        this.d_keyGenerator.endReserveKeys();
    }

    private final void beginCustomCommand(byte command, Class<? extends INativeObject> clazz, int key) {
        Integer classKey = this.d_classKeyMap.get(clazz);
        if (classKey == null) {
            classKey = this.registerClass(clazz);
        }
        this.beginCommand(command);
        this.writeInt(classKey);
        this.writeInt(key);
    }

    private final void beginStaticCustomCommand(byte command, Class<? extends INativeObject> clazz) {
        Integer classKey = this.d_classKeyMap.get(clazz);
        if (classKey == null) {
            classKey = this.registerClass(clazz);
        }
        this.beginCommand(command);
        this.writeInt(classKey);
    }

    private final void beginFullCommand(byte command, INativeObject obj) {
        this.beginCustomCommand(command, obj.resolveNativeClass(), obj.getKey());
    }

    private final void beginSimpleCommand(byte command, INativeObject obj) {
        this.beginCommand(command);
        this.writeInt(obj.getKey());
    }

    public final void markPeerDirty(INativelyMirrored obj) {
        this.updatePeer(obj);
    }

    public final void createPeer(INativeObject obj) {
        this.beginFullCommand((byte)0, obj);
        this.endCommand();
    }

    public final void createPeers(Collection<? extends INativeObject> objs) {
        for (INativeObject iNativeObject : objs) {
            this.createPeer(iNativeObject);
        }
    }

    public final void createPeer(Class<? extends INativeObject> type, int key) {
        this.beginCustomCommand((byte)0, type, key);
        this.endCommand();
    }

    public final void registerPeer(INativeObject obj, int key, long cptr) {
        this.beginFullCommand((byte)5, obj);
        this.writeLong(cptr);
        this.endCommand();
    }

    private final void updatePeer(INativelyMirrored obj) {
        this.beginSimpleCommand((byte)2, obj);
        obj.writeNativeData(this);
        this.endCommand();
        obj.markNativeClean();
    }

    private final void updatePeers(Collection<? extends INativelyMirrored> objs) {
        for (INativelyMirrored iNativelyMirrored : objs) {
            this.updatePeer(iNativelyMirrored);
        }
    }

    public final void execMethod(Class type, INativeObject obj, Enum methodID, Object ... args) {
        this.execMethod(type, obj, methodID.ordinal(), args);
    }

    public final void execMethod(Class type, INativeObject obj, int methodID, Object ... args) {
        this.beginCustomCommand((byte)3, type, obj.getKey());
        this.writeInt(methodID);
        this.writeObjects(args);
        this.endCommand();
    }

    public final void execThrowable(Class type, INativeObject obj, Enum methodID, Object ... args) throws Throwable {
        this.execThrowable(type, obj, methodID.ordinal(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execThrowable(Class type, INativeObject obj, int methodID, Object ... args) throws Throwable {
        this.lockWriteBuffer();
        try {
            this.execMethod(type, obj, methodID, args);
            this.flushThrowable();
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public final void execStaticMethod(Class type, Enum methodID, Object ... args) {
        this.execStaticMethod(type, methodID.ordinal(), args);
    }

    public final void execStaticMethod(Class type, int methodID, Object ... args) {
        this.beginStaticCustomCommand((byte)4, type);
        this.writeInt(methodID);
        this.writeObjects(args);
        this.endCommand();
    }

    public <T> T exec(Class clazz, INativeObject obj, Enum method, Function<NativeManager, T> get, Object ... args) {
        return this.exec(clazz, obj, method.ordinal(), get, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T exec(Class clazz, INativeObject obj, int method, Function<NativeManager, T> get, Object ... args) {
        this.lockWriteBuffer();
        try {
            this.execMethod(clazz, obj, method, args);
            this.flush();
            T t = get.apply(this);
            return t;
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public <T> T execGet(Class clazz, INativeObject obj, Enum method, Class<T> returnType, Object ... args) {
        return this.execGet(clazz, obj, method.ordinal(), returnType, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execGet(Class clazz, INativeObject obj, int method, Class<T> returnType, Object ... args) {
        this.lockWriteBuffer();
        try {
            this.execMethod(clazz, obj, method, args);
            this.flush();
            T t = this.read(returnType);
            return t;
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public void exec(Class clazz, INativeObject obj, Enum method, Consumer<NativeManager> after, Object ... args) {
        this.exec(clazz, obj, method.ordinal(), after, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec(Class clazz, INativeObject obj, int method, Consumer<NativeManager> after, Object ... args) {
        this.lockWriteBuffer();
        try {
            this.execMethod(clazz, obj, method, args);
            this.flush();
            after.accept(this);
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public void execThrowable(Class clazz, INativeObject obj, Enum method, Consumer<NativeManager> after, Object ... args) throws Throwable {
        this.execThrowable(clazz, obj, method.ordinal(), after, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execThrowable(Class clazz, INativeObject obj, int method, Consumer<NativeManager> after, Object ... args) throws Throwable {
        this.lockWriteBuffer();
        try {
            this.execThrowable(clazz, obj, method, args);
            after.accept(this);
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public <T> T execThrowable(Class clazz, INativeObject obj, Enum method, Function<NativeManager, T> get, Object ... args) throws Throwable {
        return this.execThrowable(clazz, obj, method.ordinal(), get, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execThrowable(Class clazz, INativeObject obj, int method, Function<NativeManager, T> get, Object ... args) throws Throwable {
        this.lockWriteBuffer();
        try {
            this.execThrowable(clazz, obj, method, args);
            T t = get.apply(this);
            return t;
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    public final void deletePeer(INativeObject obj) {
        this.scheduleFlush(5000L);
        this.beginSimpleCommand((byte)1, obj);
        this.endCommand();
    }

    public final void deletePeers(Collection<? extends INativeObject> objs) {
        for (INativeObject iNativeObject : objs) {
            this.deletePeer(iNativeObject);
        }
    }

    @Override
    public Keyable read() {
        int classKey = this.readInt();
        if (classKey < 0) {
            return null;
        }
        int key = this.readInt();
        long cptr = this.readLong();
        return this.readObject(classKey, key, cptr);
    }

    public Keyable readObject(int classKey, int key, long cptr) {
        Keyable obj;
        if (classKey < 0) {
            return null;
        }
        Integer okey = null;
        if (key != 0 && (obj = this.d_keyGenerator.get(okey = Integer.valueOf(key))) != null) {
            return obj;
        }
        return this.newJavaPeer(classKey, okey, cptr);
    }

    private Keyable newJavaPeer(int classKey, Integer key, long cptr) {
        Throwable[] caughtExc = new Throwable[]{null};
        Constructor ctor = s_nativeConstructors.computeIfAbsent(classKey, c -> {
            try {
                Class<? extends INativeObject> clazz = this.getClassForKey((int)c);
                if (clazz == null) {
                    throw new ClassNotFoundException(String.format("No Java class found for key: %d", c));
                }
                return clazz.getDeclaredConstructor(Integer.class, Long.TYPE);
            }
            catch (Throwable t) {
                assert (false);
                throwableArray[0] = t;
                return null;
            }
        });
        if (caughtExc[0] != null) {
            throw new RuntimeException(caughtExc[0]);
        }
        assert (ctor != null);
        try {
            boolean accessible = ctor.isAccessible();
            ctor.setAccessible(true);
            Keyable obj = (Keyable)ctor.newInstance(key, cptr);
            ctor.setAccessible(accessible);
            return obj;
        }
        catch (Throwable e) {
            assert (false);
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void flush() {
        try {
            super.flush();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public final void flushThrowable() throws IOException {
        super.flush();
    }

    @Override
    protected void dispatch(ByteBuffer writeBuffer, ByteBuffer readBuffer) throws Throwable {
        this.d_lastCommandLengthB = this.getWritePosition() - this.d_lastCommandPosition;
        if (this.d_numCommands == 1) {
            this.d_firstCommandLengthB = this.d_lastCommandLengthB;
        }
        Throwable thrownExc = null;
        try {
            Runnable dispatchRunner = () -> this.dispatch(writeBuffer, readBuffer, this.d_numCommands, this.d_commandStatus, this.d_firstCommandLengthB, this.d_lastCommandLengthB);
            this.d_executor.submit(dispatchRunner).get();
        }
        catch (ExecutionException e) {
            thrownExc = e.getCause();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.d_numCommands = this.d_commandStatus == 1 ? 1 : 0;
        this.d_lastCommandPosition = 0;
        ++this.d_numFlushes;
        if (thrownExc != null) {
            throw thrownExc;
        }
    }

    public void resetFlushCount() {
        this.lockWriteBuffer();
        this.d_numFlushes = 0;
        this.unlockWriteBuffer();
    }

    public int getFlushCount() {
        return this.d_numFlushes;
    }
}

