/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.nativexfer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.util.Keyable;

public class NativeKeyedObject
implements Serializable,
Keyable,
Cloneable {
    static final long serialVersionUID = 1L;
    private transient Integer d_key = null;

    public NativeKeyedObject() {
        this.ensureKeyed();
    }

    protected NativeKeyedObject(Integer key) {
        if (key == null) {
            this.ensureKeyed();
        } else {
            this.d_key = key;
            Native.keygen.registerKey(this, key);
        }
    }

    protected void ensureKeyed() {
        if (this.d_key != null) {
            return;
        }
        this.d_key = Native.keygen.generateKey(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.ensureKeyed();
    }

    protected void finalize() throws Throwable {
        Native.keygen.returnKey(this.d_key, this);
        this.d_key = null;
    }

    public static Keyable get(int key) {
        return Native.keygen.get(key);
    }

    @Override
    public Integer getKey() {
        return this.d_key;
    }

    public Object clone() {
        NativeKeyedObject cloned = null;
        try {
            cloned = (NativeKeyedObject)super.clone();
            cloned.d_key = null;
            cloned.ensureKeyed();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return cloned;
    }
}

