/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io.nativexfer;

import java.io.Flushable;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.util.Keyable;
import thunderheadeng.util.theUtil;

public abstract class ABufferedNativeStream
implements INativeStream,
Flushable {
    public static final int DEFAULT_CAPACITY = 0x100000;
    private ByteBuffer d_writeBuffer;
    private final ReentrantLock d_bufferLock = new ReentrantLock();
    private ByteBuffer d_readBuffer;
    private boolean d_isDispatching = false;
    private Timer d_flushTimer = null;
    private final CustomList<Keyable> d_strongReferences = new CustomList(262144);
    private int d_numStrongRefsFinished = 0;
    private final List<Keyable> d_strongNativeRefs = new ArrayList<Keyable>();
    private static Map<Class, BiConsumer<ABufferedNativeStream, ?>> s_writers = new LinkedHashMap();
    private static Map<Class, Function<ABufferedNativeStream, ?>> s_readers = new LinkedHashMap();
    private static Map<Class, BiConsumer<ABufferedNativeStream, ?>> s_arrayReaders = new LinkedHashMap();

    public ABufferedNativeStream() {
        this(0x100000, 0x100000);
    }

    public ABufferedNativeStream(int writeCapacity, int readCapacity) {
        this.d_writeBuffer = ByteBuffer.allocateDirect(writeCapacity).order(ByteOrder.nativeOrder());
        this.d_readBuffer = ByteBuffer.allocateDirect(readCapacity).order(ByteOrder.nativeOrder());
    }

    public boolean setWriteCapacity(int capacity) {
        this.lockWriteBuffer();
        if (this.getWritePosition() != 0) {
            this.unlockWriteBuffer();
            return false;
        }
        this.d_writeBuffer = ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
        this.unlockWriteBuffer();
        return true;
    }

    public void lockWriteBuffer() {
        assert (!this.d_isDispatching || !this.d_bufferLock.isHeldByCurrentThread());
        this.d_bufferLock.lock();
    }

    public void unlockWriteBuffer() {
        this.d_bufferLock.unlock();
        if (!this.d_bufferLock.isLocked()) {
            this.d_strongNativeRefs.clear();
        }
    }

    protected void registerNativeObj(Keyable obj) {
        if (this.d_bufferLock.isLocked()) {
            this.d_strongNativeRefs.add(obj);
        }
    }

    public final int getWritePosition() {
        return this.d_writeBuffer.position();
    }

    @Override
    public final void write(Keyable val) {
        this.d_strongReferences.add(val);
        this.checkBuffer(4);
        this.d_writeBuffer.putInt(val != null ? val.getKey() : 0);
    }

    @Override
    public final void write(Keyable ... vals) {
        for (Keyable val : vals) {
            this.write(val);
        }
    }

    @Override
    public void write(Collection<? extends Keyable> vals) {
        for (Keyable keyable : vals) {
            this.write(keyable);
        }
    }

    @Override
    public final void writeBoolean(boolean val) {
        this.checkBuffer(1);
        this.d_writeBuffer.put(val ? (byte)1 : 0);
    }

    @Override
    public final void writeBooleans(boolean ... vals) {
        for (boolean val : vals) {
            this.writeBoolean(val);
        }
    }

    @Override
    public final void writeByte(byte val) {
        this.checkBuffer(1);
        this.d_writeBuffer.put(val);
    }

    @Override
    public final void writeBytes(byte ... vals) {
        for (byte val : vals) {
            this.writeByte(val);
        }
    }

    @Override
    public final void writeShort(short val) {
        this.checkBuffer(2);
        this.d_writeBuffer.putShort(val);
    }

    @Override
    public final void writeShorts(short ... vals) {
        for (short val : vals) {
            this.writeShort(val);
        }
    }

    @Override
    public final void writeLong(long val) {
        this.checkBuffer(8);
        this.d_writeBuffer.putLong(val);
    }

    @Override
    public final void writeLongs(long ... vals) {
        for (long val : vals) {
            this.writeLong(val);
        }
    }

    @Override
    public void writeChar(char val) {
        this.checkBuffer(2);
        this.d_writeBuffer.putChar(val);
    }

    @Override
    public void writeChars(char ... vals) {
        for (char val : vals) {
            this.writeChar(val);
        }
    }

    @Override
    public final void writeInt(int val) {
        this.checkBuffer(4);
        this.d_writeBuffer.putInt(val);
    }

    @Override
    public final void writeInts(int ... vals) {
        for (int val : vals) {
            this.writeInt(val);
        }
    }

    @Override
    public final void writeFloat(float val) {
        this.checkBuffer(4);
        this.d_writeBuffer.putFloat(val);
    }

    @Override
    public final void writeFloats(float ... vals) {
        for (float val : vals) {
            this.writeFloat(val);
        }
    }

    @Override
    public final void writeDouble(double val) {
        this.checkBuffer(8);
        this.d_writeBuffer.putDouble(val);
    }

    @Override
    public final void writeDoubles(double ... vals) {
        for (double val : vals) {
            this.writeDouble(val);
        }
    }

    @Override
    public void writeString(String str) {
        if (str == null) {
            this.writeInt(0);
            return;
        }
        this.writeInt(str.length());
        for (int m = 0; m < str.length(); ++m) {
            char c = str.charAt(m);
            this.writeChar(c);
        }
    }

    @Override
    public void writeStrings(String ... strs) {
        for (String s : strs) {
            this.writeString(s);
        }
    }

    public static <T> void registerWriter(Class<T> type, BiConsumer<ABufferedNativeStream, T> writer) {
        s_writers.put(type, writer);
    }

    public static <T> void registerReader(Class<T> type, Function<ABufferedNativeStream, T> reader) {
        s_readers.put(type, reader);
    }

    public static <T> void registerArrayReader(Class<T> type, BiConsumer<ABufferedNativeStream, T> reader) {
        s_arrayReaders.put(type, reader);
    }

    @Override
    public void writeObject(Object obj) {
        if (obj == null) {
            this.writeInt(0);
        } else {
            this.writeNonNull(obj);
        }
    }

    private void writeNonNull(Object obj) {
        Class<?> c = obj.getClass();
        BiConsumer<ABufferedNativeStream, ?> writer = s_writers.get(c);
        if (writer == null) {
            writer = theUtil.findObjectForArrayClass(false, s_writers, c);
            if (writer == null) {
                assert (false) : "ABufferedNativeStream.writeObject failed: didn't recognize object type, " + obj.getClass();
                return;
            }
            s_writers.put(c, writer);
        }
        writer.accept(this, obj);
    }

    @Override
    public void writeObjects(Object ... objs) {
        for (Object obj : objs) {
            this.writeObject(obj);
        }
    }

    public void writeObjects(Collection<?> objs) {
        for (Object o : objs) {
            this.writeObject(o);
        }
    }

    @Override
    public void read(Keyable ... vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.read();
        }
    }

    @Override
    public void read(int count, Collection<Keyable> vals) {
        for (int m = 0; m < count; ++m) {
            vals.add(this.read());
        }
    }

    @Override
    public boolean readBoolean() {
        return this.d_readBuffer.get() != 0;
    }

    @Override
    public void readBooleans(boolean[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.get() != 0;
        }
    }

    @Override
    public byte readByte() {
        return this.d_readBuffer.get();
    }

    @Override
    public void readBytes(byte[] vals) {
        this.d_readBuffer.get(vals, 0, vals.length);
    }

    @Override
    public short readShort() {
        return this.d_readBuffer.getShort();
    }

    @Override
    public void readShorts(short[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getShort();
        }
    }

    @Override
    public long readLong() {
        return this.d_readBuffer.getLong();
    }

    @Override
    public void readLongs(long[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getLong();
        }
    }

    @Override
    public char readChar() {
        return this.d_readBuffer.getChar();
    }

    @Override
    public void readChars(char[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getChar();
        }
    }

    @Override
    public int readInt() {
        return this.d_readBuffer.getInt();
    }

    @Override
    public void readInts(int[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getInt();
        }
    }

    @Override
    public float readFloat() {
        return this.d_readBuffer.getFloat();
    }

    @Override
    public void readFloats(float[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getFloat();
        }
    }

    @Override
    public double readDouble() {
        return this.d_readBuffer.getDouble();
    }

    @Override
    public void readDoubles(double[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.d_readBuffer.getDouble();
        }
    }

    public double[] readDoubles(int count) {
        double[] vals = new double[count];
        this.readDoubles(vals);
        return vals;
    }

    @Override
    public String readString() {
        int count = this.readInt();
        char[] chars = new char[count];
        for (int m = 0; m < count; ++m) {
            chars[m] = this.readChar();
        }
        return new String(chars);
    }

    @Override
    public void readStrings(String[] vals) {
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = this.readString();
        }
    }

    public <T> T read(Class<T> c) {
        Function<ABufferedNativeStream, ?> reader = ABufferedNativeStream.getReader(s_readers, c);
        if (reader == null) {
            return null;
        }
        return (T)reader.apply(this);
    }

    private static <T> T getReader(Map<Class, T> map, Class c) {
        T reader = map.get(c);
        if (reader == null) {
            reader = theUtil.findObjectForArrayClass(false, map, c);
            if (reader == null) {
                assert (false) : "ABufferedNativeStream.getReader failed: didn't recognize object type, " + c.getName();
                return null;
            }
            map.put(c, reader);
        }
        return reader;
    }

    public <CompT> void readArray(Class<CompT> c, Object array) {
        assert (c.isArray());
        BiConsumer<ABufferedNativeStream, ?> reader = ABufferedNativeStream.getReader(s_arrayReaders, c);
        if (reader == null) {
            return;
        }
        reader.accept(this, array);
    }

    public <ArrayT> ArrayT readArray(Class<ArrayT> c, int count) {
        assert (c.isArray());
        Object arr = Array.newInstance(c.getComponentType(), count);
        this.readArray(c, arr);
        return (ArrayT)arr;
    }

    private final void checkBuffer(int desiredWriteCount) {
        assert (desiredWriteCount <= this.d_writeBuffer.capacity());
        if (desiredWriteCount > this.d_writeBuffer.remaining()) {
            this.forceFlushUncaught();
        }
    }

    protected void markStrongRefsFinished() {
        this.d_numStrongRefsFinished = this.d_strongReferences.size();
    }

    private void clearFinishedStrongRefs() {
        int numUnfinished = this.d_strongReferences.size() - this.d_numStrongRefsFinished;
        if (numUnfinished == 0) {
            this.d_strongReferences.clear();
        } else {
            this.d_strongReferences.removeRange(0, this.d_numStrongRefsFinished);
        }
        this.d_numStrongRefsFinished = numUnfinished;
    }

    @Override
    public void flush() throws IOException {
        this.lockWriteBuffer();
        try {
            this.forceFlush();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
        finally {
            this.unlockWriteBuffer();
        }
    }

    private final void forceFlushUncaught() {
        try {
            this.forceFlush();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private final void forceFlush() throws Throwable {
        this.cancelScheduledFlush();
        if (this.d_writeBuffer.position() == 0) {
            return;
        }
        try {
            this.d_isDispatching = true;
            this.dispatch(this.d_writeBuffer, this.d_readBuffer);
            this.d_isDispatching = false;
        }
        finally {
            this.clearFinishedStrongRefs();
            this.d_writeBuffer.position(0);
            this.d_readBuffer.position(0);
        }
    }

    protected abstract void dispatch(ByteBuffer var1, ByteBuffer var2) throws Throwable;

    public final synchronized void scheduleFlush(long delayms) {
        if (this.d_flushTimer == null) {
            this.d_flushTimer = new Timer();
            this.d_flushTimer.schedule((TimerTask)new FlushTask(), delayms);
        }
    }

    public final synchronized void cancelScheduledFlush() {
        if (this.d_flushTimer != null) {
            this.d_flushTimer.cancel();
            this.d_flushTimer = null;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int end = off + len;
        for (int m = off; m < end; ++m) {
            this.writeByte(b[m]);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.writeByte((byte)v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeShort((short)v);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeChar((char)v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        for (int m = 0; m < len; ++m) {
            char c = s.charAt(m);
            this.writeByte((byte)(0xFF & c));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        for (int m = 0; m < len; ++m) {
            this.writeChar(s.charAt(m));
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF-8");
        if (bytes.length > 65535) {
            throw new UTFDataFormatException();
        }
        this.writeShort(bytes.length);
        this.write(bytes);
    }

    @Override
    public void close() throws IOException {
    }

    static {
        ABufferedNativeStream.registerWriter(Byte.class, ABufferedNativeStream::writeByte);
        ABufferedNativeStream.registerReader(Byte.class, ABufferedNativeStream::readByte);
        ABufferedNativeStream.registerWriter(byte[].class, ABufferedNativeStream::writeBytes);
        ABufferedNativeStream.registerArrayReader(byte[].class, ABufferedNativeStream::readBytes);
        ABufferedNativeStream.registerWriter(Short.class, ABufferedNativeStream::writeShort);
        ABufferedNativeStream.registerReader(Short.class, ABufferedNativeStream::readShort);
        ABufferedNativeStream.registerWriter(short[].class, ABufferedNativeStream::writeShorts);
        ABufferedNativeStream.registerArrayReader(short[].class, ABufferedNativeStream::readShorts);
        ABufferedNativeStream.registerWriter(Long.class, ABufferedNativeStream::writeLong);
        ABufferedNativeStream.registerReader(Long.class, ABufferedNativeStream::readLong);
        ABufferedNativeStream.registerWriter(long[].class, ABufferedNativeStream::writeLongs);
        ABufferedNativeStream.registerArrayReader(long[].class, ABufferedNativeStream::readLongs);
        ABufferedNativeStream.registerWriter(Boolean.class, ABufferedNativeStream::writeBoolean);
        ABufferedNativeStream.registerReader(Boolean.class, ABufferedNativeStream::readBoolean);
        ABufferedNativeStream.registerWriter(boolean[].class, ABufferedNativeStream::writeBooleans);
        ABufferedNativeStream.registerArrayReader(boolean[].class, ABufferedNativeStream::readBooleans);
        ABufferedNativeStream.registerWriter(Character.class, ABufferedNativeStream::writeChar);
        ABufferedNativeStream.registerReader(Character.class, ABufferedNativeStream::readChar);
        ABufferedNativeStream.registerWriter(char[].class, ABufferedNativeStream::writeChars);
        ABufferedNativeStream.registerArrayReader(char[].class, ABufferedNativeStream::readChars);
        ABufferedNativeStream.registerWriter(Integer.class, ABufferedNativeStream::writeInt);
        ABufferedNativeStream.registerReader(Integer.class, ABufferedNativeStream::readInt);
        ABufferedNativeStream.registerWriter(int[].class, ABufferedNativeStream::writeInts);
        ABufferedNativeStream.registerArrayReader(int[].class, ABufferedNativeStream::readInts);
        ABufferedNativeStream.registerWriter(Float.class, ABufferedNativeStream::writeFloat);
        ABufferedNativeStream.registerReader(Float.class, ABufferedNativeStream::readFloat);
        ABufferedNativeStream.registerWriter(float[].class, ABufferedNativeStream::writeFloats);
        ABufferedNativeStream.registerArrayReader(float[].class, ABufferedNativeStream::readFloats);
        ABufferedNativeStream.registerWriter(Double.class, ABufferedNativeStream::writeDouble);
        ABufferedNativeStream.registerReader(Double.class, ABufferedNativeStream::readDouble);
        ABufferedNativeStream.registerWriter(double[].class, ABufferedNativeStream::writeDoubles);
        ABufferedNativeStream.registerArrayReader(double[].class, ABufferedNativeStream::readDoubles);
        ABufferedNativeStream.registerWriter(Keyable.class, ABufferedNativeStream::write);
        ABufferedNativeStream.registerReader(Keyable.class, INativeStream::read);
        ABufferedNativeStream.registerWriter(Keyable[].class, ABufferedNativeStream::write);
        ABufferedNativeStream.registerArrayReader(Keyable[].class, ABufferedNativeStream::read);
        ABufferedNativeStream.registerWriter(String.class, ABufferedNativeStream::writeString);
        ABufferedNativeStream.registerReader(String.class, ABufferedNativeStream::readString);
        ABufferedNativeStream.registerWriter(String[].class, ABufferedNativeStream::writeStrings);
        ABufferedNativeStream.registerArrayReader(String[].class, ABufferedNativeStream::readStrings);
        ABufferedNativeStream.registerWriter(Object[].class, ABufferedNativeStream::writeObjects);
        ABufferedNativeStream.registerWriter(Collection.class, ABufferedNativeStream::writeObjects);
    }

    private static class CustomList<T>
    extends ArrayList<T> {
        public CustomList(int capacity) {
            super(capacity);
        }

        @Override
        public void removeRange(int from, int to) {
            super.removeRange(from, to);
        }
    }

    private final class FlushTask
    extends TimerTask {
        private FlushTask() {
        }

        @Override
        public void run() {
            ABufferedNativeStream.this.d_flushTimer = null;
            ABufferedNativeStream.this.lockWriteBuffer();
            ABufferedNativeStream.this.forceFlushUncaught();
            ABufferedNativeStream.this.unlockWriteBuffer();
        }
    }
}

