/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Optional;

public enum TextFileEncoding {
    UTF32BE("UTF-32BE", 0, 0, 254, 255),
    UTF32LE("UTF-32LE", 255, 254, 0, 0),
    UTF8("UTF-8", 239, 187, 191),
    UTF16BE("UTF-16BE", 254, 255),
    UTF16LE("UTF-16LE", 255, 254);

    public final String name;
    public final byte[] bom;

    private TextFileEncoding(String name, int ... bom) {
        this.bom = new byte[bom.length];
        for (int m = 0; m < bom.length; ++m) {
            this.bom[m] = (byte)bom[m];
        }
        this.name = name;
    }

    public static Optional<TextFileEncoding> find(byte[] bom) {
        for (TextFileEncoding enc : TextFileEncoding.values()) {
            if (!enc.equalsBOM(bom)) continue;
            return Optional.of(enc);
        }
        return Optional.empty();
    }

    private boolean equalsBOM(byte[] bom) {
        if (bom.length < this.bom.length) {
            return false;
        }
        for (int m = 0; m < this.bom.length; ++m) {
            if (bom[m] == this.bom[m]) continue;
            return false;
        }
        return true;
    }

    public static Optional<TextFileEncoding> read(FileInputStream in) throws IOException {
        byte[] bom = new byte[4];
        int bomLen = in.read(bom);
        if (bomLen == -1) {
            return Optional.empty();
        }
        Optional<TextFileEncoding> enc = TextFileEncoding.find(Arrays.copyOf(bom, bomLen));
        int bomlen = enc.map(e -> e.bom.length).orElse(0);
        in.getChannel().position(bomlen);
        return enc;
    }

    public void writeBOM(OutputStream out) throws IOException {
        out.write(this.bom);
    }
}

