/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LegacyDictionary {
    private static final String s_arrayBegin = "[L";
    private static final String s_arrayEnd = ";";
    private final int d_version;
    private final NavigableMap<Integer, Map<String, Class>> d_classLookup = new TreeMap<Integer, Map<String, Class>>();

    public LegacyDictionary(int currVersion) {
        this.d_version = currVersion;
    }

    public void addLegClass(int version, String legName, Class newClass) {
        HashMap<String, Class> versionMap = (HashMap<String, Class>)this.d_classLookup.get(version);
        if (versionMap == null) {
            versionMap = new HashMap<String, Class>();
            this.d_classLookup.put(version, versionMap);
        }
        versionMap.put(legName, newClass);
    }

    public Class resolveClass(String className) {
        Collection lookups = this.d_classLookup.tailMap(this.d_version, false).values();
        if (lookups.isEmpty()) {
            return null;
        }
        int arrayDepth = 0;
        while (className.startsWith(s_arrayBegin) && className.endsWith(s_arrayEnd)) {
            ++arrayDepth;
            className = className.substring(s_arrayBegin.length(), className.length() - s_arrayEnd.length());
        }
        Class<?> clazzFound = null;
        for (Map lookup : lookups) {
            Class<?> clazz = (Class<?>)lookup.get(className);
            if (clazz == null) continue;
            if (arrayDepth > 0) {
                int m;
                StringBuffer newName = new StringBuffer(clazz.getName().length() + arrayDepth * (s_arrayBegin.length() + s_arrayEnd.length()));
                for (m = 0; m < arrayDepth; ++m) {
                    newName.append(s_arrayBegin);
                }
                newName.append(clazz.getName());
                for (m = 0; m < arrayDepth; ++m) {
                    newName.append(s_arrayEnd);
                }
                try {
                    clazz = Class.forName(newName.toString());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            className = clazz.getName();
            clazzFound = clazz;
        }
        return clazzFound;
    }
}

