/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.io;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import thunderheadeng.Intl;

public class KeyboardAcceleratorIO {
    private static final String ROOT_ID = "hotkeys";
    private static final String ACTION_ROOT_ID = "function";
    private static final String KS_ID = "keystroke";
    private static final String MODS_ID = "modifiers";

    public static void loadHotKeys(IKeyboardAcceleratorHelper helper) {
        try {
            FileReader reader = new FileReader(helper.getDefaultFileLocation());
            JSONParser jsonParser = new JSONParser();
            JSONObject rootObj = (JSONObject)jsonParser.parse((Reader)reader);
            LinkedHashMap<String, KeyStroke> funcNameToKS = new LinkedHashMap<String, KeyStroke>();
            JSONArray funcArray = (JSONArray)rootObj.get((Object)ROOT_ID);
            for (JSONObject func : funcArray) {
                String funcName = (String)func.get((Object)ACTION_ROOT_ID);
                if (funcNameToKS.containsKey(funcName)) continue;
                int keycode = (int)((Long)func.get((Object)KS_ID)).longValue();
                int mods = (int)((Long)func.get((Object)MODS_ID)).longValue();
                KeyStroke ks = KeyStroke.getKeyStroke(keycode, mods);
                funcNameToKS.put(funcName, ks);
            }
            helper.updateActionMap(funcNameToKS);
        }
        catch (IOException | NullPointerException | ParseException e) {
            System.out.println(Intl.intl("Keyboard accelerator preferences not detected. Loading defaults"));
            helper.updateActionMap(Collections.emptyMap());
        }
    }

    public static void exportHotKeys(IKeyboardAcceleratorHelper helper) {
        JSONObject rootObj = new JSONObject();
        JSONArray listOfAccelerators = new JSONArray();
        for (String actionKey : helper.getSortedActionList()) {
            KeyStroke ks = helper.getKeyStrokeForActionKey(actionKey);
            if (ks == null) continue;
            JSONObject func = new JSONObject();
            func.put((Object)ACTION_ROOT_ID, (Object)actionKey);
            func.put((Object)KS_ID, (Object)ks.getKeyCode());
            func.put((Object)MODS_ID, (Object)ks.getModifiers());
            listOfAccelerators.add((Object)func);
        }
        rootObj.put((Object)ROOT_ID, (Object)listOfAccelerators);
        try (FileWriter fout = new FileWriter(helper.getDefaultFileLocation());){
            fout.write(rootObj.toJSONString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface IKeyboardAcceleratorHelper {
        public String getDefaultFileLocation();

        public void updateActionMap(Map<String, KeyStroke> var1);

        public Collection<String> getSortedActionList();

        public KeyStroke getKeyStrokeForActionKey(String var1);
    }
}

